/**
 * sumit.meena
 */
var evalGroupDocumentGridStore = Ext.create('Academia.store.examinationcenters.evaluationgroup.document.EvalGroupDocumentGrid');
Ext.define('Academia.view.examinationcenters.evaluationgroup.documents.EvalGroupDocumentGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.evalgroupdocumentsgrid',
    store: evalGroupDocumentGridStore,
    border: true,
    autoScroll: false,
    frame:false,
    title:getExaminationTranslation('DOCUMENT_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	 initComponent: function() {
	        var grid=this;                   
	        grid.addExportToolBarItems(grid);
	        this.callParent(arguments);     
	 },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : evalGroupDocumentGridStore,
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getExaminationTranslation('DOCUMENT_NAME'),
        dataIndex: 'documentCode',
        flex:.4,
        sortable:true
    }, {
        header: getExaminationTranslation('DOCUMENT_TYPE'),
        dataIndex: 'documentType',
        flex:.3,
        sortable: true,
        renderer: function(value){
        	return capitaliseEnumValue(value);
        }
    }, {
        header: getExaminationTranslation('DROOLS_RULE'),
        dataIndex: 'droolsRule',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('DROOLS_RULE_DESC'),
        dataIndex: 'droolsRuleDescription',
        flex:.3,
        sortable: true
    }]
});