/**
 * @author Ashutosh Bhawsar<ashutosh.bhawsar@serosoft.in>
 * 
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.evaluationgroupdetail.DownloadGroupFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.downloadgroupfilter',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	plugins:"formlabelrequired",
	plugins:"formlabelrequired",
	items: [{
			xtype: 'radiogroup',
			itemId:'assessmentGroupId',
			name: 'assessmentGroup',
			labelAlign:'top',			
			columns: 2,
			vertical: true,
			items : [{
	   	   		 boxLabel : getExaminationTranslation('ASSESSMENT_GROUP_DETAIL'),
	   	   		 name : 'assessmentGroupDetail',
	   	   		 itemId:'assessmentGroupDetailItemId',
	   	   		 inputValue : 'forAssessmentGroupDetail',
	   	   		 checked : true
	   	   		 
	   	   	 },{
	   	   		 boxLabel : getExaminationTranslation('ASSESSMENT_EVENTS_COVERED'),
	   	   		 name : 'assessmentGroupDetail',
	   	   		 itemId:'assessmentEventsCoveredItemId',
	   	   		 inputValue : 'forAssessmentEventsCovered'
	   	   	 }]
		    },
		
		{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'evaluationType',
			itemId:'evaluationTypeItemId',
			store:'examCenter.AssignSequence.EvaluationType',
			value:'Academics',
			readOnly:true,
			displayField:'value',
			valueField:'id',
			hidden:true,
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
		},{
	        	xtype: 'customcombobox',
	            name: 'evaluationGroupId',
	            itemId: 'evaluationGroupId',
	            store:'examinationcenters.examstaffallocation.commonFilter.ExamImportGroupFilter',
	            fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
	  			displayField: 'value',
	  			queryParam:'textSearch',
	  			minChars:3,
	  			typeAhead:false,
	  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	  			enableKeyEvents  : 'true',
	  			hideTrigger:false,
	  			forceSelection:true,
	  			hidden:true,
	  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	  			listConfig: {
	  				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	  				loadingText: getCommonTranslation('SEARCHING'),
	  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	  				getInnerTpl: function() {
	  					return '<div class="search-item">' +
	  					'{value}' +
	  					'</div>';
	  				}
	  			},
	  			listeners: {
	  				select: function(combo, records){
						var appForm = combo.up('form');
						appForm.down('#groupDownload').setDisabled(false);
						
					}
	  			}
		        }]
		},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		items: [{
			xtype:'button',
			itemId:'groupDownload',
			text:getExaminationTranslation('ASSESSMENT_GROUP_DOWNLOAD'),
			ui: 'CustomBtnSubmit',
			disabled:true
//			formBind:true
		}, 
		{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
