/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.evaluationgroupdetail.EvalGroupProgramGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.evalgroupprogramgrid',
	store: 'examinationcenters.evaluationgrouplisting.applicationdetail.GroupProgramGridStore',
	title: getExaminationTranslation('MAP_PROGRAMS_GRID'),
	border: true,
	autoScroll: false,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [{
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.evaluationgrouplisting.applicationdetail.GroupProgramGridStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	}]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	 tbar: [{
	        xtype: 'button',
	        itemId: 'searchResultGridBtnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    },{
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	    }],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:getExaminationTranslation('BATCH') ,
		dataIndex: 'batchName',
		flex:.1,
		sortable:true,
	},{
		header:getCommonTranslation('TOTAL_COURSE_VARIANTS'),
		dataIndex: 'courseCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.courseCount == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},{
		header: getExaminationTranslation('OTHER_EVENT_COUNT'),
		dataIndex: 'otherEventCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.otherEventCount == 0){
					return value;
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	}]
});