/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationresult.EvaluationResultCourseGrid',{
	//extend:'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store:'examinationcenters.evaluationresult.EvaluationResultCourse',
	alias:'widget.evaluationresultcoursegrid',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : 'examinationcenters.evaluationresult.EvaluationResultCourse',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid = this;
		//grid.scrollable = true;
		//grid.height = 450;
		grid.cls = 'sticky-grid-header';
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
 },
    columns:[{
	  	header : getExaminationTranslation('ADMISSION_ID'),
	  	dataIndex : 'admissionCode',
	  	flex:1
   },{
	  	header : getExaminationTranslation('STUDENT_ID'),
	  	dataIndex : 'studentCode',
	  	flex:1
   },{
	  	header : getExaminationTranslation('STUDENT_NAME'),
	  	dataIndex : 'studentName',
	  	flex:1
   },{
	  	header : getExaminationTranslation('EVENT'),
	  	dataIndex : 'event',
	  	flex:1
   },{
	  	header : getCommonTranslation('COURSE_CODE_NAME'),
	  	dataIndex : 'courseName', 
	  	flex:1
   },{
	  	header : getExaminationTranslation('MARK_GRADE'),
	  	dataIndex : 'grade',
	  	flex:1,
	  	renderer:function(value,r,rec){
	  		if(rec.data.status=="ABSENT"){
	  			return "Absent";
	  		}else{
	  			if(!isNullOrEmpty(rec.data.obtainedMarks)){
		  			return rec.data.obtainedMarks;
		  		}else if(!isNullOrEmpty(rec.data.grade)){
		  			return rec.data.grade;	  			
		  		}	
	  		}
	  	}
   },{
	  	header : getExaminationTranslation('STATUS'),
	  	dataIndex : 'status',
	  	flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value))
				return getExaminationTranslation(value);
			else
				return ''
		}
   }]
});


