/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationresult.EvaluationResultStudentFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.evaluationresultstudentfilter',
	autoScroll: false,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items:[{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	margin:'0 0 0 -10',
    	defaults: {
    		width: 452,
    		labelAlign: 'top'
    	},
    	items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            name: 'academyLocationComboExamination',
            itemId: 'academyLocationComboExamination',
			style:{marginLeft:'10px'},
            store: 'examinationcenters.evaluationresult.AcademyLocationExamCenter',
            displayField: 'value',
            editable:false,
			typeAhead:false,
            forceSelection:true,
            //margin:'0 0 0 -5',
            valueField: 'id',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{academyLocationName}' +
					'</div>';
				}
			}
        }]
    },{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'studentId',
			itemId:'studentItemId',
			store: 'examinationcenters.reports.ExaminationReportStudentStore',
			fieldLabel:getExaminationTranslation("STUDENT_ID_NAME"),
			valueField: 'parentId',
			displayField: 'studentCodeValueResult',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'admissionId',
			itemId:'admissionItemId',
			store: 'attendance.AdmissionSearchByStudent',
			fieldLabel : getExaminationTranslation('ADMISSION_ID'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'code',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'programId',
			itemId: 'programItemId',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'servicerequest.placementrequest.PlacementPrograms',
			displayField:'valueSecondValue',
			valueField:'programId',
			forceSelection:true,
			typeAhead:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			queryParam:'name',
			disabled:true,			
			minChars:3,			
			listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId: 'batchItemId',
			fieldLabel:getExaminationTranslation('BATCH'),
			store:'common.CurrentBatchStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			allowBlank:false
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			fieldLabel:getExaminationTranslation('PERIOD'),
			store:'program.programDetails.programBatches.courseParameter.EvaluationResultStudentStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			allowBlank:false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'sectionId',
			itemId: 'sectionItemId',
			fieldLabel:getExaminationTranslation('SECTION'),
			store:'attendance.SectionAndFacultyByPeriodID',
			displayField:'sectionCode',
			valueField:'sectionId',
			maxLength:10000,
			forceSelection:true,
			autoloadStore: false,
			editable:false,
			typeAhead:true,
			disabled:true,
			cls:'placementProgramMultiselect'
		},{
			xtype: 'customcombobox',
			name: 'evaluationLevel',
			itemId: 'evaluationLevelItemId',
			fieldLabel:getExaminationTranslation('EVALUATION_LEVEL'),
			store:'examinationcenters.evaluationresult.EvaluationLevel',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			allowBlank:false
		}]
	},
	{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			/*xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseItemId',
			fieldLabel:getExaminationTranslation('COURSE'),
			store:'course.CourseComboStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			//allowBlank:false
*/			

        	xtype: 'customcombobox',
			name:'courseId',
			itemId:'courseItemId',
			store:'servicerequest.withdrawfromcourseprogramservice.Courses',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			hidden:true,
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'variantId',
			itemId: 'variantItemId',
			fieldLabel:getExaminationTranslation('VARIANT'),
			store:'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
			displayField:'code',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			hidden:true,
			disabled:true,
			//allowBlank:false
		}]
	},
	{
		xtype: 'fieldcontainer',
		width:'100%',
		cls:'windowBtnPos',
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});