/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evalution.coverageDetails.ProgramBatchSectionCoverageForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.programbatchsectioncoverageform',
    modal: true,
    autoScroll:true,
    title: getExaminationTranslation('PROGRAM_BATCH_SECTION'),
    width: '43%',
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll:true
        },
        plugins:"formlabelrequired",
        standardSubmit: false,
        
        items: [{
           	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    		items:[{
    			    xtype:'hidden',
    			    name:'id'
    		     },{
	   			    xtype:'hidden',
				    name:'version'
		        },{
	   			    xtype:'hidden',
				    name:'evaluationPlanId'
		        },{
		        	
		        	xtype: 'customcombobox',
		  			name:'programId',
		  			itemId:'programIdItemId',
		  			store:'common.ProgramStore',
		  			fieldLabel:getExaminationTranslation('PROGRAM'),
		  			valueField: 'id',
		  			displayField: 'value',
		  			queryParam:'programName',
		  			minChars:3,
		  			//width:460,
		  			typeAhead:false,
		  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		  			enableKeyEvents  : 'true',
		  			hideTrigger:false,
		  			forceSelection:true,
		  			allowBlank:false,
		  			//hidden:true,
		  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		  			listConfig: {
		  				listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		  				loadingText: getCommonTranslation('SEARCHING'),
		  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		  				getInnerTpl: function() {
		  					return '<div class="search-item">' +
		  					'{value}' +
		  					'</div>';
		  				}
		  			}  
    				/* xtype: 'customcombobox',
    			     name: 'programId',
    			     itemId:'programIdItemId',
    			     fieldLabel: getExaminationTranslation('PROGRAM'),
    			     store:'common.ProgramStore',
    			     displayField:'value',
    			     valueField:'id',
    			     forceSelection:true,
    			     typeAhead:true,
    			     emptyText:getCommonTranslation('SELECT_COMBOBOX'),
    			     allowBlank: false*/
    		   },{
					 xtype: 'customcombobox',
				     name: 'batchId',
				     store:'common.BatchesByProgramId',
				     displayField:'value',
				     valueField:'id',
				     itemId:'batchIdItemId',
				     forceSelection:true,
				     typeAhead:true,
				     disabled:true,
				     fieldLabel: getExaminationTranslation('BATCH'),
				     emptyText:getCommonTranslation('SELECT_COMBOBOX'),
				     allowBlank: false
					}]
    		},{
        	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    	items:[{
				 xtype: 'customcombobox',
			     name: 'periodId',
			     fieldLabel: getExaminationTranslation('PERIOD'),
			     store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			     displayField:'value',
			     valueField:'id',
			     forceSelection:true,
			     typeAhead:true,
			     disabled:true,
			     itemId:'periodIdItemId',
			     emptyText:getCommonTranslation('SELECT_COMBOBOX'),
			     allowBlank: false
			},{
				 xtype: 'customcombobox',
			     name: 'sectionId',
			     fieldLabel: getExaminationTranslation('SECTION'),
			     store:'attendance.SectionOfEnrollmentStudentByPeriodID',
//			     store:'coursetransaction.sectionmanagement.SectionsStore',
			     displayField:'sectionCode',
			     valueField:'sectionId',
			    // forceSelection:true,
			     typeAhead:true,
			     disabled:true,
			     emptyText:getCommonTranslation('SELECT_COMBOBOX'),
			     allowBlank: false
			}]
        },{
        	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 226,
    			labelAlign:'top'
    		},
    	items:[{
				xtype: 'customcombobox',
				name:'facultyId',
				itemId:'facultyId_itemId',
				store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.FacultyCombo',{
			        listeners: {
			            beforeload: function(store, operation, options){
			            	store.proxy.extraParams.academyLocationIds = Academia.app.getAcademiaControllerBaseBaseControllerController().getCurrentAcademyLocation();
			            	store.proxy.extraParams.restrictToAL = true;
			            	store.proxy.extraParams.restrictToFacultyRole = true;
			            }
			        }
				}),
				fieldLabel :getCommonTranslation('FACULTY_CODE_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'nameOrCode',
				minChars:3,
				typeAhead:false,
				enableKeyEvents  : 'true',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: 'all',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
		      xtype : 'customcombobox',
	       	  name : 'completionStatus',
	       	  fieldLabel : getExaminationTranslation('COMPLETION_STATUS'),
	       	  store : 'feeandpayment.SequenceStatus',
	       	  valueField : 'id',
	       	  displayField : 'value',
	       	  allowBlank: false
			}]
        },
        {
        	xtype: 'fieldcontainer',
            width:'100%',
            cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                action : 'Submit',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSave',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});