/**
 * @Author Raghavendra.Soni
 */
Ext.define('Academia.view.examinationcenters.evalution.evaluationDetail.MappedProgramsTabFilter', { 
	extend : 'Ext.form.Panel',
	alias : 'widget.mappedprogramstabfilter',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
	collapsed: true,
	collapsible: true,
	title: getCommonTranslation('SEARCH_FILTERS'),
	items : [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
		items :[{
			xtype: 'customcombobox',
			width: 460,
			name: 'academyLocation_MPFilter',
			itemId: 'academyLocation_MPFilter_ItemId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'examinationcenters.evaluation.coverageDetails.EvaluationPlanMappedALStore',
			displayField:'value',
			valueField:'id',
			autoloadStore: false,
			allowBlank:true,
			queryParam:'academyLocationName',
			minChars:3,
			typeAhead:false,
			labelAlign: 'top',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'programCategoryId_MPFilter',
			itemId:'programCategoryId_MPFilter_ItemId',
			store:'program.ProgramCategoryByAlAndProgramStore',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			fieldLabel:getCommonTranslation('PROGRAM_CATEGORY'),
		}]
	},{
		xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
		items:[{
			xtype: 'customcombobox',
			name:'programId_MPFilter',
			itemId:'programId_MPFilter_ItemId',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			store:'common.MappedProgramListOtherEvalStore',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			hideTrigger:false,
        	triggerAction: 'all',
        	minChars:3,
        	queryParam:'programName',
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{value}'  +
        			'</div>';
        		}
        	}
		},{
			xtype: 'customcombobox',
			name: 'batchId_MPFilter',
			itemId:'batchId_MPFilter_ItemId',
			store:'common.CurrentBatchStore',
			displayField:'value',
			valueField:'id',
			disabled:true,
			//forceSelection:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('BATCH')
		},{
			xtype: 'customcombobox',
			name: 'periodId_MPFilter',
			itemId:'periodId_MPFilter_ItemId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField:'value',
			valueField:'id',
			disabled:true,
			//forceSelection:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('PERIOD')
		}]
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
        style: 'margin-top:5px;left:-2px;',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'quickSearchId_MPFilter_ItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true,
            style: 'margin-left:0 !important;'
        },{
        	xtype: 'button',
			itemId: 'resetBtn_MPFilter_ItemId',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});