/**
 * Santosh Sahu
 */
Ext.define('Academia.view.examinationcenters.examSpecialGrade.CriteriaBasedGradeGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.criteriabasedgradegrid',
	store: 'examinationcenters.reports.CriteriaBasedGradeListStore',
	border: true,
	frame:false,
	selType:'checkboxmodel',
	title:getExaminationTranslation('GRADE_CRITERIA'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
        headerFix: true,
        portalIdsWithStructure: {   
            'specialgradesearchtabform':1
        }
    },
	selModel: {
		 showHeaderCheckbox: true,
		 checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		 allowDeselect: false,
		 //injectCheckbox:1
   },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
				xtype: 'custompagingtoolbar',
				itemId:'managePaggingToolBarItemId',
				plugins:['pagesize'],
			    store : 'examinationcenters.reports.CriteriaBasedGradeListStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
 },
 tbar: [{	
	
		 xtype: 'button',
		 text:getExaminationTranslation('APPLY_CHANGES'),
		 itemId:'applyChangesId',
		 scale: CONSTANTS.BUTTONSIZE,
		 tooltip: getExaminationTranslation('APPLY_CHANGES'),
	
 	}],
	columns: [{
		header: getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.4,
		sortable:true
	},{
		header: getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.4,
		sortable:true
	},{
		header: getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	},
	{
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('COURSE_CODE'),
		dataIndex: 'courseCode',
		flex:.3,
		sortable: true,
		hidden: true
	},{
		header: getExaminationTranslation('COURSE'),
		dataIndex: 'courseName',
		flex:.3,
		sortable: true,
		hidden: true
	},{
		header: getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('ATTENDANCE_PERCENTAGE'),
		dataIndex: 'attendancePercentage',
		flex:.3,
		sortable: true,
		hidden: true
	},{
		header: getExaminationTranslation('OBTAINED_MARKS_GRADE'),
		dataIndex: 'obtainedMarksGrade',
		flex:.3,
		sortable: true
	},{
		header : getExaminationTranslation('REVISED_GRADE'),
		dataIndex : 'revisedGrade',
		flex : .3,
		editor : {
			xtype: 'customcombobox',
			name:'revisedGradeId',
			itemId:'revisedGradeItemId',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
			valueField : 'id',
			//forceSelection:true,
			//editable:false,
			typeAhead:false,
			displayField : 'gradeName',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},
		listeners:{
			click: function(){
				if(Ext.ComponentQuery.query('#revisedGradeItemId')[0])
					Ext.ComponentQuery.query('#revisedGradeItemId')[0].setValue();
			}
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			var grid = view;
			var $this= this;
			var store = grid.getStore();
			var models = grid.getStore().getRange();
			if((val=='' || val== undefined || isNullOrEmpty(val))){
				var specialGrade = record.data.specialGrade;
				if(specialGrade !='' && !isNullOrEmpty(specialGrade)){
					return specialGrade;
				} else {
					if(view.up().getCode().toUpperCase() == "AUTOMATIC".toUpperCase()){
						return '-';
					} else {
						rec.tdCls = 'gridInputCustomStyle'; 
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
			} else if(val!='' && val!= undefined){
				var grid = view.up();
				var isReturnDefault=false;
				if(grid.getMlpData){
					var ddlRecord = grid.getMlpData();
					if(isNullOrEmpty(ddlRecord) || ddlRecord.length==0){
						//store.load();
					}
					else{
						for (var i in ddlRecord) {
							if(val == ddlRecord[i].data.gradeName || val == ddlRecord[i].data.id) {
								models[rowIndex].set("revisedGrade",ddlRecord[i].data.gradeName);
								models[rowIndex].set("revisedGradeCode",ddlRecord[i].data.studentCode);
								models[rowIndex].set("revisedGradePoint",ddlRecord[i].data.gradePoint);	
								return ddlRecord[i].data.gradeName;
							}
							isReturnDefault=true;
						}
						if(isReturnDefault) {
							if(view.up().getCode().toUpperCase() == "AUTOMATIC".toUpperCase()){
								return '-';
							} else {
								rec.tdCls = 'gridInputCustomStyle'; 
								return getExaminationTranslation('CLICK_TO_ENTER');
							}
						}
					}
				}
				else {
					return val;
				}
			} else {
				if(view.up().getCode().toUpperCase() == "AUTOMATIC".toUpperCase()){
					return '-';
				} else {
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}	
		}
	},{
		header: getExaminationTranslation('REMARKS'),
		dataIndex: 'remark',
		flex:.3,
		sortable: true,
		hidden:true
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		/*listeners: {
			beforeedit: function(editor , context){
			}
		  } */
		}]
});
