/**
 * @author Manas
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.DownloadHomeworkAssignmentForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.downloadHomeworkAssignmentForm',
    plugins: "formlabelrequired",
    frame: false,
    standardSubmit: false,

    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226   
        },

        items: [{
			xtype: 'customcombobox',
			name: 'evaluationPlanId',
			itemId: 'evaluationPlanId',
			store: 'examinationcenters.evaluation.EvaluationPlanNo',
			fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam: 'qry',
			width: 226,
			allowBlank: false,
			forceSelection: true,
			enableKeyEvents: true,
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }, {
			xtype: 'multiselectcombofield',
			name: 'detailSequence',
			itemId: 'detailSequenceItemId',
			store: 'examinationcenters.manageEvaluation.HomeworkAssignmentEventStore',
			displayField: 'value',
			valueField: 'id',
			fieldLabel: getExaminationTranslation('DETAILED_SEQUENCE'),
			allowBlank: false,
			forceSelection: true,
			cls: 'resetPasswordMultiselect', 
			maxLength: 500000,
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        cls: 'windowBtnPos',   
        margin: '8 0 0 0',

        items: [{
            xtype: 'button',
            itemId: 'downloadHomeworkBtn',
            text:getExaminationTranslation('MARK_ENTRY_DOWNLOAD'), //Name for Old Tranlsations Use
            ui: 'CustomBtnSubmit',
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetHomeworkDownloadBtn',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel'
        }]
    }]
});