/**
 * @author Manas
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.UploadHomeworkAssignmentForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.uploadHomeworkAssignmentForm',
    plugins: "formlabelrequired",
    frame: false,
    standardSubmit: false,

    defaults: {
        width: 226,          
        labelAlign: 'top'
    },

    items: [{
        xtype: 'uploadoptionradiogroup',
        width: 300,
        margin: 0,
        itemId: 'homeworkUploadOptionRadioGroupItemId'
    }, 		{
		    xtype: 'textfield',
		    name: 'importUtilityMasterId',
		    itemId: 'homeworkTemplateName',
		    fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
		    value: 'Import Homework Assignments',
		    readOnly: true,
		    allowBlank: false
		}, {
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 460,         
        fieldLabel: getCommonTranslation('UPLOAD_FILE'),
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'homeworkUploadFileField',
        name: 'file',
        allowBlank: false,
        validateOnChange: true,
		listeners: {
				change: function (fileField, value) {
					value = value.replace('C:\\fakepath\\', '');
					var newValue = value.replace(/ +/g, " ").split(' ').join('_');
					fileField.setRawValue(newValue);
					if (!isNullOrEmpty(newValue)) {
						var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
						var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
						if (!baseController.isValidFileExtensionForLoader(extension)) {
							fileField.reset();
							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
						}
					}
				}
			}
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            action: 'Submit',
            text: getTranslation('UPLOAD_DATA'),
            formBind: true,
            itemId: 'uploadHomeworkBtn',
            ui: 'CustomBtnSubmit'
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            itemId: 'resetHomeworkUploadBtn'
        }]
    }]
});
