/**
 * @Author Deepak.Nigam
 */
Ext.define('Academia.view.examinationcenters.questionPaperBank.questionPaperBankDetails', {
    extend: 'Ext.form.FormPanel',
    //extend:'Academia.view.common.DynamicFieldForm',
    alias: 'widget.questionpaperbankdetails',
    //title : getExaminationTranslation('ADD_EVALUATION_PLAN'),
    overflowY: 'auto',
    layout: 'vbox',
    //cls: 'panelNoSpace',
    bodyPadding: '10 10 10 10',
    frame: true,
    //modal: true,
    style: {
        marginLeft: CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    method: 'POST',
    defaults: {
        labelAlign: 'top',
        width: 226
    },
    itemId: 'questionPaperformItemId',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'successDataId'
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            name: 'PAPER_CODE',
            itemId: 'paperCodeId',
            fieldLabel: getExaminationTranslation('PAPER_CODE'),
            editable: false,
            allowBlank: false,
            valueField: 'id',
            displayField: 'value',
            allowOnlyWhitespace: false
        }, {
            xtype: 'customcombobox',
            name: 'PAPER_STATUS',
            itemId: 'paperStatusId',
            store: 'examinationcenters.questionPaperBank.PaperStatusStore',
            fieldLabel: getExaminationTranslation('PAPER_STATUS'),
            editable: false,
            allowBlank: false,
            valueField: 'id',
            displayField: 'value'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'questionPaperBankAcademicTerm',
            itemId: 'questionPaperBankAcademicTermId',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            store: Ext.create('Academia.store.common.AcademicTermStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            typeAhead: true,
			allowBlank: false, 
            minChars: 3,
            queryMode: 'local'
        }, {
            xtype: 'customcombobox',
            name: 'evaluationplan',
            itemId: 'evalautionPlanId',
            store: 'examinationcenters.evaluationgroup.detailsequencecovered.QuestionPaperBankDetailsEvalPlanStore',
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'name',
            minChars: 3,
            allowBlank: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'courseId',
            itemId: 'courseItemId',
            store: Ext.create('Academia.store.coursetransaction.studentenrollment.enrollmentmaster.QuestionPaperBankDetailsCourseCombo'), //'coursetransaction.studentenrollment.enrollmentmaster.CourseEnrollmentCombo',
            allowBlank: false,
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            valueField: 'courseId',
            displayField: 'valueCode',
            queryParam: 'name',
            minChars: 3,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            disabled: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'detailSequence',
            itemId: 'detailSequenceItemId',
            store: 'examinationcenters.manageEvaluation.EvaluationEventByEvalPlan',
            displayField: 'value',
            valueField: 'id',
            editable: false,
            queryMode: 'local',
            fieldLabel: getExaminationTranslation('DETAILED_SEQUENCE'),
            disabled: true
        }, {
            xtype: 'customcombobox',
            name: 'PROGRAM_NAME',
            itemId: 'programId',
            store: Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.QPBProgramBatchPeriodStore'),
            fieldLabel: getExaminationTranslation('PROGRAM'),
            displayField: 'value',
            valueField: 'id',
            queryParam: 'name',  
            minChars: 3,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            disabled: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'BATCH_NAME',
            itemId: 'batchId',
            store: Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.QPBProgramBatchPeriodStore'),
            fieldLabel: getExaminationTranslation('BATCH'),
            editable: false,
            disabled: true,
            queryMode: 'local',
            displayField: 'value',
            valueField: 'id'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'PERIOD_NAME',
            itemId: 'periodId',
            store: Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.QPBProgramBatchPeriodStore'),
          //  store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
            fieldLabel: getExaminationTranslation('PERIOD'), 
            editable: false,
            disabled: true,
            queryMode: 'local',
            displayField: 'value',   
            valueField: 'id',
        }, {
            xtype: 'textfield',
            name: 'durationOfPaper',
            itemId: 'durationOfPaperId',
            fieldLabel: getExaminationTranslation('DURATION_OF_PAPER'),
            valueField: 'id',
            displayField: 'value',
            allowOnlyWhitespace: false,
            maxLength: 255,
            enforceMaxLength: true
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            name: 'dateOfAssignment',
            itemId: 'dateOfAssignment',
            //listeners: {
            //	render: function(field) {
            //		return dateFormatRender(field);
            //	}
            //},
            endDateField: 'submissionDate',
            vtype: 'daterange',
            allowBlank: false,
            //format : CONSTANTS.DISPLAY_DATE_FORMAT,
            value: new Date(),
            fieldLabel: getExaminationTranslation('DATE_ASSIGNMENT'),
            listeners: {
                render: function (obj) {
                    obj = dateFormatRender(obj);
                    obj.setMinValue(new Date());
                    obj.setValue(new Date());
                }
            },
        }, {
            xtype: 'datefield',
            name: 'dueDate',
            itemId: 'dueDateItemId',
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            },
            fieldLabel: getExaminationTranslation('DUE_DATE')
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'checkboxfield',
            name: 'manualAssignment',
            itemId: 'manualAssignmentItemId',
            boxLabel: getExaminationTranslation('MANNUAL_ASSIGNMENT'),
            inputValue: true,
            uncheckedValue: false,
            labelAlign: 'left',
            style: {
                marginTop: '15px'
            }
        }, {
            xtype: 'multiselectcombofield',
            name: 'suggestedNames',
            itemId: 'suggestedNamesItemId',
            store: 'examinationcenters.questionPaperBank.suggestedUserNamesQuetionPaper',
            fieldLabel: getExaminationTranslation('SUGGESTED_NAMES'),
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            typeAhead: false,
            maxLength: 50000,
            width: 460
        }, {
            xtype: 'multiselectcombofield',
            fieldLabel: 'User Name',
            name: 'USER_NAME',
            itemId: 'user_name',
            store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
            msgTarget: 'qtip',
            valueField: 'id',
            displayField: 'value',
            queryParam: 'name',
            typeAhead: false,
            hidden: true,
            width: 460,
            allowBlank: false,
            disabled: true
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getExaminationTranslation('SUBMITED_BY'),
            name: 'SUBMITTED_BY',
            itemId: 'submittedById',
            store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
            msgTarget: 'qtip',
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'name',
            minChars: 3,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'datefield',
            name: 'submissionDate',
            itemId: 'submissionDate',
            vtype: 'daterange',
            startDateField: 'dateOfAssignment',
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            },
            fieldLabel: getExaminationTranslation('DATE_OF_SUBMISSION')
        }, {
            xtype: 'customcombobox',
            name: 'SUBMISSION_STATUS',
            itemId: 'submissionStatusId',
            store: 'examinationcenters.questionPaperBank.PendingSubmittedStatusStore',
            fieldLabel: getExaminationTranslation('SUBMISSION_STATUS'),
            editable: false,
            hidden: true,
            valueField: 'id',
            displayField: 'value'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 460,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textarea',
            fieldLabel: getExaminationTranslation('DESCRIPTION'),
            name: 'DESC',
            itemId: 'desc'
        }]
    }, {
        xtype: 'displayfield',
        hidden: true,
        value: '<b class="menu-title">' + getCourseTxCommonTranslation('UPLOAD_DOC') + '</b>',
        style: {
            textDecoration: "underline"
        }
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'filefield',
            border: false,
            hidden: true,
            name: 'courseReadingLinks',
            allowBlank: true,
            buttonText: getCommonTranslation('UPLOAD_DOC')
        }]
    }, {
        xtype: 'questionpaperdocumentgrid',
        style: {
            marginLeft: '0px'
        }
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            itemId: 'submitBtn',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'cancelBtn',
            hidden: true,
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            name: 'questionPaperDocument',
            text: getCommonTranslation('UPLOAD_DOC'),
            itemId: 'questionPaperDocumentUploadId',
            ui: 'CustomBtnThird',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});