/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.remark.ClassTeacherRemarkGrid',{
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.classteacherremarkgrid',
	store: 'examinationcenters.remark.ClassTeacherRemarkGridStore',
	title:getExaminationTranslation('CLASS_TEACHER_REMARK_LIST'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		//showHeaderCheckbox: false,
		checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.remark.ClassTeacherRemarkGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [ {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getExaminationTranslation('ENTER_REMARK'),
		text:getExaminationTranslation('ENTER_REMARK')
		/* }, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip: getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'
	    }, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH*/
	}, {
	    xtype: 'button',
	    itemId: 'btnFPGenerateComment',
	    text: getExaminationTranslation('GENERATE_COMMENT'),
	    cls: 'generate-remark-btn',
	    scale: CONSTANTS.BUTTONSIZE,
	    disabled: true
	}, {	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSaveItemId',
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE'),
			style:{
//				marginLeft:'5px',
				marginRight:'10px'
			}
		}]
	}],
	columns: [{
		header: getCommonTranslation('STUDENT_IMAGE'),
		dataIndex: 'photoUrl',
		sortable:false,
		flex:.08,
		renderer: function(value, metaData) {
			if(!isNullOrEmpty(this.xtype) && this.xtype.toLowerCase() != "exportallgrid"){
				metaData.tdAttr = 'type="gridImageCell"';
				if(!isNullOrEmpty(value) && value !=0){
					//var extension=value.substring(value.length-4, value.length);
					var extensionArr = value.split(".");
					if (value.indexOf("https") != -1) {
						var imageUrl = value;
					}
					else {
						var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
					}
					value='<img src="'+imageUrl+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px;">';
					return value;
				}else{
					if (value && value.indexOf("https") != -1) {
						var imageUrl = value;
					}
					else {
						var imageUrl="resources/images/profile_student.png";
					}
					value='<img src="'+imageUrl+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px">';
					return value;
				}
			}
		}
	},{
		header: getCommonTranslation('ADMISSION_CODE'),
		dataIndex: 'admissionCode',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('FIRST_NAME'),
		dataIndex: 'firstName',
		flex:.1,
		hidden: true
	},{
		header: getCommonTranslation('MIDDLE_NAME'),
		dataIndex: 'middleName',
		flex:.1,
		sortable: true,
		hidden: true
	},{
		header: getCommonTranslation('LAST_NAME'),
		dataIndex: 'lastName',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('GENDER'),
		dataIndex: 'gender',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				return getExaminationTranslation(val);
			}
		}
	},/*{
         header: getExaminationTranslation('PERIOD'),
         dataIndex: 'periodName',
         flex:.1,
         sortable: true
     }*/{
		header: getCommonTranslation('SECTION_ID'),
		dataIndex: 'sectionId',
		flex:.1,
		hidden: true
	},{
		header: getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('AVERAGE_MARKS'),
		dataIndex: 'marksAverage',
		flex:.1,
		hidden:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val) && val>0){
				return val;
			}else{
				return '-';
			}
		}
	},{
		header: getCommonTranslation('REMARK'),
		dataIndex: 'remark',
		flex:.2,
		sortable:true,
		editor : {
			xtype: 'customcombobox',
			name:'remarkValue',
			itemId:'remarkValueItemId',
			store:Ext.create('Academia.store.examinationcenters.remark.CourseEvaluationGridRemark'),
			valueField : 'value',
			displayField : 'value',
			maxLength:1500,
			editable:true,
			//	vtype:'hindiChare',
			listeners:{
				change: function(cmb){
					var comboValue = cmb.getValue();
					var comboValueLen = comboValue.length;
					if(comboValueLen >= 1500){
						showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('MAX_CHARACTER_1500_ALLOWED')); 
						var newValue = comboValue.slice(0,1500);
						cmb.setValue(newValue);	                	
						return false;
					}
				},
				afterrender: function(cmp) {
					cmp.store.on('beforeload', function(store) {
						try {
							var extraParams = store.getProxy().extraParams;
							var vals = cmp.up('grid').up('evaluationremarkmasterstructure').down('classteacherremarksfilter').getValues();
							Object.assign(extraParams, {
								programId: vals.programId
							});
							store.getProxy().extraParams = extraParams;
						}
						catch(e) {}
					});
				},
				focus:function(cmp){
					try {
						var store = cmp.getStore();
						var extraParams = store.getProxy().extraParams;
						var vals = cmp.up('grid').up('evaluationremarkmasterstructure').down('classteacherremarksfilter').getValues();
						Object.assign(extraParams, {
							programId: vals.programId
						});
						store.getProxy().extraParams = extraParams;
						store.load();
					}
					catch(e) {}
				}
			},
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				getInnerTpl: function(displayField) { 
					return '<tpl if="xindex%2==0"><div class="oddColorCombo" style="width:404px"></tpl><tpl if="xindex%2==1"><div class="evenColorCombo" style="width:404px"></tpl> {' + displayField + '} </div>';
				} 
			}
		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				rec.tdCls = 'gridInputCustomStyle'; 
				return getExaminationTranslation('CLICK_TO_ENTER');
			}else{
				/*if(val.length>100 && view.editingPlugin!=undefined){
	    			var valtext='';
	    			valtext=val.substring(0, 100)+"...";
	    			rec.tdAttr = 'data-qtip="' + val + '"';
	    			return valtext;
	    		}
	    		else
	    		{
	    			return val;
	    		}*/
				rec.tdAttr = 'data-qtip="' + val + '"';
				//rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				//rec.tdCls ="assign-remark-column-cls";
				return val;
			}
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1
		/*listeners: {
            beforeedit: function(editor , context){
            }
          } */
	}]
});
