/**
 * sumit.meena
 */
var gridStore = Ext.create('Academia.store.examinationcenters.remark.EvaluationRemarkGridStore');
Ext.define('Academia.view.examinationcenters.remark.EvaluationRemarkGrid',{
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.evaluationremarkgrid',
	store: gridStore,
	title:getExaminationTranslation('MANAGE_EVALUATION_REMARK_LIST'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		//showHeaderCheckbox: false,
		checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : gridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [/*{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getExaminationTranslation('ADD_REMARK'),
	        text:getExaminationTranslation('ADD_REMARK'),
	        //glyph: ICONGLYPH.ADDGLYPH
	    },*/
		{
			xtype: 'button',
			itemId: 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip: getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH
		}, {
			xtype: 'button',
			itemId: 'btnEdit',
			tooltip: getExaminationTranslation('ENTER_REMARK'),
			text:getExaminationTranslation('ENTER_REMARK'),
		},
		//glyph: ICONGLYPH.EDITGLYPH
		/* }, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip: getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'
	    }, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH*/
		{
			xtype: 'button',
			itemId: 'btnGenerateComment',
			text:getExaminationTranslation('GENERATE_COMMENT'),
			cls : 'generate-remark-btn',
			scale : CONSTANTS.BUTTONSIZE,
			disabled: true
		}, 
		{	
			xtype:'fieldcontainer',
			layout : 'hbox',
			cls:'windowBtnPos',
			defaults: {
				labelAlign:'top',
			},
			items:[{
				xtype: 'button',
				itemId: 'btnSaveItemId',
				tooltip: getExaminationTranslation('SAVE'),
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				text:getExaminationTranslation('SAVE'),
				style:{
					//marginLeft:'5px',
					marginRight:'10px'
				}
			}]
		}
		],
		columns: [{
			header: getCommonTranslation('STUDENT_IMAGE'),
			dataIndex: 'photoUrl',
			sortable:false,
			flex:.08,
			renderer: function(value, metaData) {
				if(!isNullOrEmpty(this.xtype) && this.xtype.toLowerCase() != "exportallgrid"){
					metaData.tdAttr = 'type="gridImageCell"';
					if(!isNullOrEmpty(value) && value !=0){

						//var extension=value.substring(value.length-4, value.length);
						var extensionArr = value.split(".");
						if(value.indexOf("https") != -1){
							var imageUrl=value;
						}
						else{
							var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
						}
						value='<img src="'+imageUrl+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px;">';
						return value;
					}else{

						if(value && value.indexOf("https") != -1){
							var imageUrl=value;
						}
						else{
							var imageUrl="resources/images/studentProfileImg.png";
						}
						value='<img src="'+imageUrl+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px">';
						return value;
					}
				}
			}
		},	{
			header: getCommonTranslation('ADMISSION_CODE'),
			dataIndex: 'admissionCode',
			flex:.1,
			sortable: true
		}, {
			header: getCommonTranslation('STUDENT_ID'),
			dataIndex: 'studentCode',
			flex:.1,
			sortable: true,
		},{
			header: getCommonTranslation('STUDENT_NAME'),
			dataIndex: 'studentName',
			flex:.1,
			sortable: true
		},{
			header: getCommonTranslation('FIRST_NAME'),
			dataIndex: 'firstName',
			flex:.2,
			sortable: true,
			hidden: true
		},{
			header: getCommonTranslation('MIDDLE_NAME'),
			dataIndex: 'middleName',
			flex:.1,
			sortable: true,
			hidden: true
		},{
			header: getCommonTranslation('LAST_NAME'),
			dataIndex: 'lastName',
			flex:.1,
			sortable: true
		},{
			header: getCommonTranslation('GENDER'),
			dataIndex: 'gender',
			flex:.1,
			sortable: true,
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(!isNullOrEmpty(val)){
					return getExaminationTranslation(val);
				}
			}
		},{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
			flex:.1,
			sortable: true
		},{
			header: getCommonTranslation('BATCH'),
			dataIndex: 'batchName',
			flex:.1,
			sortable: true
		},/*{
         header: getExaminationTranslation('PERIOD_ID'),
         dataIndex: 'periodId',
         flex:.1,
         hidden: true
     },*/{
			header: getCommonTranslation('PERIOD'),
			dataIndex: 'periodName',
			flex:.1,
			sortable: true
		},/*{
         header: getExaminationTranslation('SECTION_ID'),
         dataIndex: 'sectionId',
         flex:.1,
         hidden: true
     },*/{
			header: getCommonTranslation('SECTION'),
			dataIndex: 'sectionName',
			flex:.1,
			sortable: true
		},/*{
	     header: getExaminationTranslation('COURSE_VARIANT_ID'),
	     dataIndex: 'courseVariantId',
	     flex:.1,
	     hidden: true
	 },*/{
			header: getCommonTranslation('COURSE_VARIANT'),
			dataIndex: 'courseVariantCode',
			flex:.3,
			hidden: false
		},{
			header: getCommonTranslation('OBTAINED_MARKS'),
			dataIndex: 'totalMarks',
			flex:.1,
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(!isNullOrEmpty(val)){
					return val;
				}else{
					return '-';
				}
			}
		},{
			header: getCommonTranslation('OBTAINED_GRADE'),
			dataIndex: 'totalGrade',
			flex:.1,
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(!isNullOrEmpty(val)){
					return val;
				}else{
					return '-';
				}
			}
		},{
			header: getCommonTranslation('REMARKS'),
			dataIndex: 'remark',
			flex:.4,
			sortable:true,
			editor : {
				xtype: 'customcombobox',
				name:'remarkValue',
				itemId:'remarkValueItemId',
				store:Ext.create('Academia.store.examinationcenters.remark.CourseEvaluationGridRemark'),
				valueField : 'value',
				displayField : 'value',
				editable:true,
				maxLength:1500,
				//	vtype:'hindiChare',
				listeners:{
					afterrender: function(cmp) {
						cmp.store.on('beforeload', function(store) {
							try {
								var extraParams = store.getProxy().extraParams;
								var vals = cmp.up('grid').up('evaluationremarkmasterstructure').down('form').getValues();
								if(vals.evaluationplantype != "ACADEMICS") {
								
									store.getProxy().extraParams = {
										evaluationPlanId: vals.evaluationPlan
									}
								}
								else {
								
									store.getProxy().extraParams ={
										courseId: vals.courseId
									} 
								}
							}
							catch(e) {}
						});
					},
					change: function(cmb){
						var comboValue = cmb.getValue();
						if(comboValue){
						var comboValueLen = comboValue.length;
						if(comboValueLen >= 1500){
							showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('MAX_CHARACTER_1500_ALLOWED')); 
							var newValue = comboValue.slice(0,1500);
							cmb.setValue(newValue);	                	
							return false;
						}
						}
					},
					focus:function(cmp){
						var rec = cmp.up('grid').getSelectionModel().getSelection()[0];
						if(rec && rec.data && rec.data.whetherManualCourseLevelRemark == false){
							cmp.setEditable(false);
						}else{
							cmp.setEditable(true);
						}
						if(cmp.getStore() && cmp.getStore().data && cmp.getStore().data.items && !cmp.getStore().data.items.length){
							cmp.getStore().load({
					            callback: function (records, opt, success) {
					                if (success) {
					                	if(!records.length && rec && rec.data){
					                		try{
					                		cmp.setValue(rec.data.remark)
					                		rec.set('remark',rec.data.remark)
					                		}catch(e){
					                			
					                		}
					                	}
					                }
					            }
					        });
						}
						/*else {  // V2D-471728
							try {
								var store = cmp.getStore();
								var extraParams = store.getProxy().extraParams;
								var vals = cmp.up('grid').up('evaluationremarkmasterstructure').down('form').getValues();
								Object.assign(extraParams, {
									programId: vals.programId
								});
								store.getProxy().extraParams = extraParams;
								store.load();
							}
							catch(e) {}
						}*/
						
					}
				},
				listConfig: { 
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					getInnerTpl: function(displayField) { 
						return '<tpl if="xindex%2==0"><div class="oddColorCombo" style="width:404px"></tpl><tpl if="xindex%2==1"><div class="evenColorCombo" style="width:404px"></tpl> {' + displayField + '} </div>';
					} 
				}
			},
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					/*if(val.length>100 && view.editingPlugin!=undefined){
	    			var valtext='';
	    			valtext=val.substring(0, 100)+"...";
	    			rec.tdAttr = 'data-qtip="' + val + '"';
	    			return valtext;
	    		}
	    		else
	    		{
	    			return val;
	    		}*/
					rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
					//rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
					rec.tdCls ="assign-remark-column-cls";
					return val;
				}
			}
		},{
			header: getCommonTranslation('GENERIC_REMARK'),
			dataIndex: 'genericRemark',
			flex:.3,
			hidden: true,
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(!isNullOrEmpty(val)) {
					rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"'; 
					//rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
					return val;}else{
						return "";
					}


			}
		}, {
			header: getCommonTranslation('EVIDENCE'),
			dataIndex:"evidence",
			hidden: true,
			menuDisabled: true,
			sortable: false,
			width: 100,
			itemId: 'evidencePreviewBtn',
			renderer: function(value, meta, record) {
				//if(isImageOrPDFDocument(record.data.path)){
				return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;line-height: 20px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 4px 10px;" >'+getCommonTranslation('PREVIEW')+'</a>';
				/*}
        	else{
        		return "-";
        	}*/
			},
			getEditor: function(record){
				return null;
			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1
		}]
});
