/**
 * bhanu pratap singh

 */
var gridStore = Ext.create('Academia.store.examinationcenters.reports.anonymousreportfilter.AnonymousStudentListStore');
Ext.define('Academia.view.examinationcenters.reports.AnonymousReportGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
    alias: 'widget.anonymousreportgrid',
    store: gridStore,
    border: true,
    refreshStoreData:true,
    title:getExaminationTranslation('LIST_OF_STUDENT'),
    frame:false,
    viewConfig: {
        stripeRows: false
    },
    isGridConfigurable: true,
	enableColumnHide: false,
    selModel: {
    	mode:'MULTI',
    	showHeaderCheckbox: true,
    	allowDeselect: false,
    	checkOnly : true
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
            store: gridStore,
        	emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
    tbar:['->',
   	 {
        	xtype: 'button',
            text: getExaminationTranslation('EXPORT_BARCODE_REPORT'),
            itemId: 'btnExportBarcodeReport',
            //ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }
    ],
    columns: [{
        header: getExaminationTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex:.4,
        sortable:true
    }, {
        header: getExaminationTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('UNIQUE_CODE'),
        dataIndex: 'uniqueCode',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE'),
        dataIndex: 'courseName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('EVALUATION_PLAN'),
        dataIndex: 'evaluationPlanName',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('DETAIL_SEQUENCE'),
        dataIndex: 'evaluationEventName',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('MARKS_OBTAIN'),
        dataIndex: 'totalMarksObtained',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('MAX_MARKS'),
        dataIndex: 'maxMarks',
        flex:.3,
        sortable: true
    },{
        header: getExaminationTranslation('GRADE'),
        dataIndex: 'totalGradeAward',
        flex:.3,
        sortable: true
    }],
    plugins: [{
   	  ptype : 'cellediting',
   	  clicksToEdit: 1
     }]
});
