/**
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.examinationcenters.reports.CrossListReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.crosslistreportgrid',
	store: 'examinationcenters.reports.CrossListReportGridStore',
	title: getExaminationTranslation('CROSS_LIST_REPORT'),
	border: true,
	refreshStoreData:true,
	frame:false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.reports.CrossListReportGridStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
    /*tbar : ['->',{
	    xtype : 'button',
	    itemId : 'exportCrossListReportsId',
	    tooltip : getExaminationTranslation('EXPORT_CROSS_LIST_REPORT'),
	    text : getExaminationTranslation('EXPORT_CROSS_LIST_REPORT'),
	    formBind:true,
	}],*/
	columns: [{
		header:  getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('PROGRAM_NAME'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getProgramandcourseTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getProgramandcourseTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getProgramandcourseTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('FAIL_COURSE_COUNT'),
		dataIndex: 'failCourseCount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(value==0) {
				return value;
			} else {
				return '<a href=#>'+value+'</a>'
			}
		}
	}]
});
