/**
 * @author Deepika 
 */
var reportStore = Ext.create('Academia.store.examinationcenters.reports.ExaminationResultReportGridStore')
Ext.define('Academia.view.examinationcenters.reports.ExaminationResultReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.examinationresultreportgrid',
	store: reportStore,
	title: getExaminationTranslation('EXAMINATION_RESULTS_REPORT'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'examinationresultreportstructure': 2
    	}
    },
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : reportStore,
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('PROGRAM_ID'),
		dataIndex: 'programId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH_ID'),
		dataIndex: 'batchId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('EVALUATION_PLAN_ID'),
		dataIndex: 'evaluationPlanId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM_NAME'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH_NAME'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.2,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariant',
		flex:.5,
		sortable:true
	},{
		header:  getCommonTranslation('EVALUATION_PLAN_NUMBER'),
		dataIndex: 'evaluationPlanName',
		flex:.5,
		sortable:true
	},{
		header:  getCommonTranslation('ADMISSION_NO'),
		dataIndex: 'admissionCode',
		flex:.2,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable:true
	},{
		header:  getCommonTranslation('FIRST_NAME'),
		dataIndex: 'firstName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('MIDDLE_NAME'),
		dataIndex: 'middleName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('LAST_NAME'),
		dataIndex: 'lastName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('MAX_MARKS'),
		dataIndex: 'maxMarks',
		flex:.2,
		sortable:true
	},{
		header:  getCommonTranslation('MAX_GRADE'),
		dataIndex: 'maxGrade',
		flex:.2,
		sortable:true
	},{
		header:  getCommonTranslation('OBTAINED_MARKS'),
		dataIndex: 'obtainedMarks',
		flex:.2,
		sortable:true
	},{
		header:  getCommonTranslation('EFFECTIVE_MARKS'),
		dataIndex: 'effectiveMarks',
		flex:.2,
		sortable:true
	},{
		header:  getCommonTranslation('GRADE_OBTAINED'),
		dataIndex: 'gradeObtained',
		flex:.2,
		sortable:true
	},{
		header:  getCommonTranslation('GERMAN_GRADE_SCALE'),
		dataIndex: 'germanGradeScale',
		flex:.2,
		sortable:true
	},{
		header:  getCommonTranslation('GRADE_POINT'),
		dataIndex: 'gradePoint',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SECTION_WISE_COURSE_RANK'),
		dataIndex: 'sectionRank',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_RANK'),
		dataIndex: 'courseRank',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex:.2,
		sortable:true,
		renderer:function(value){
			if(value){
				if(value == "PASS"){
					return "<span style=\'color:green\'>Pass</span>";
				}else if(value == "FAIL"){
					return "<span style=\'color:red\'>Fail</span>";
				}else{
					return value;
				}
			}
		}
	},{
		header:  getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_VARIANT_ID'),
		dataIndex: 'courseVariantId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SECTION_ID'),
		dataIndex: 'sectionId',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('REVISED_GRADE_OBTAINED'),
		dataIndex: 'revisedGradeObtained',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('USER_STATUS'),
		dataIndex: 'userStatus',
		flex:.1,
		sortable:true
	}]
});
