/**
 * @author Manas
 */
Ext.define('Academia.view.examinationcenters.reports.ViewGeneratedDetailsWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.viewgenerateddetailswin',
	title : getCommonTranslation('VIEW_GENERATED_REPORT'),
	modal: true,
	autoScroll:true,
	//maxHeight:250,
	width: '65%',
	height:'40%',
	items: [{
		xtype:'grid',
		itemId:'viewGrid',
		store :  'examinationcenters.reports.ViewReportsGridStore',
		border: true,
		autoScroll: false,
		refreshStoreData:true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store :    'examinationcenters.reports.ViewReportsGridStore',
				emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		
		columns: [
		{
			header : getCommonTranslation('REPORT_TYPE'),
			dataIndex : 'reportType',
			flex : 1,
			sortable:true
		}
		,{
					header : getCommonTranslation('GENERATION_DATE'),
					dataIndex : 'generatedDate',
					flex : 1,
					sortable:true,
					renderer :function(value,record){
						if(!isNullOrEmpty(value)){
							var val = new Date(value);
							var formatedDate = moment(val, "DD/MM/YYYY").format("DD/MM/Y");
							return formatedDate;
		    			}
					}
					
				}
				,
		{
			header : getCommonTranslation('GENERATED_BY'),
			dataIndex : 'generatedBy',
			flex : 1,
			sortable:true
		},{
			header : getCommonTranslation('PERIOD_LEVEL_REPORT'),
			dataIndex : 'filePath',
			flex : 1,
			sortable:true,
			renderer :function(value,record){
				if(!isNullOrEmpty(value)){
    				return  '<a href="#">'+value+'</a>';
    			}
			}
		}]
	}]
});