/**
 * Dharmendra.p 
 */
Ext.define('Academia.view.examinationcenters.reports.examinationdocuments.ExaminationDocumentsWin',{
	extend: 'Ext.window.Window',
	alias : 'widget.examinationdocumentswin',
	title : getExaminationTranslation('EXAM_DOCUMENTS'),
	frame: true,
	autoScroll:true,
	modal:true, 
	method: 'POST',
	height: '55%',
	width: '45%',
	items : [{
		xtype: 'dynamicfieldformwin',
	    customFieldEntity:CONSTANTS.EXAMINATION_DOCUMENT_CD,
	    columns: 2,
		standardSubmit : false,
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top'
		},
		items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'hidden',
		name:'documentPath'
	},{
		xtype:'hidden',
		name:'version'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'examDocumentNameId',
			fieldLabel : getExaminationTranslation('DOCUMENT_NAME'),
			store:'examinationcenters.reports.ExaminationDocumentNameFilter',
			valueField : 'id',
			displayField : 'value',
			editable : false,
			allowBlank : false, 
            selectOnFocus: true,
            forceSelection: false
			
		},{
			xtype : 'datefield',
			fieldLabel :getExaminationTranslation('DOCUMENT_UPLOAD_DATE'),
			name : 'uploadDate',
			itemId : 'uploadDate',
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			editable :false,
//			value:new Date()
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textarea',
			align : 'left',
			width: 460,
			fieldLabel : getExaminationTranslation('DESCRIPTION'),
			name : 'description',
			itemId : 'description'
		}]
	},{
		xtype:'fieldcontainer',
		width:'auto',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'filefield',
			fieldLabel: getExaminationTranslation('UPLOAD_DOCUMENT'),
			buttonText: getExaminationTranslation('UPLOAD'),
			itemId: 'examinationDocument',
			allowBlank:false,
			ui: 'CustomBtnSubmit',
			name: 'file',
		/*	listeners:{
				change: function(field, val) { 
	                var fileName = /^.*\.(exe)$/i;
	                if(fileName.test(val)){
	                	field.reset();
	                	showWarningMessage(getCommonTranslation('UPLOAD_DOCUMENT'),getCommonTranslation('CANNOT_UPLOAD_EXE_FILE'));
	                	return false;
	                }
	          }
			}*/
		}]},{
		xtype:'fieldcontainer',
		width:'100%',
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'saveBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype : 'button',
			text : getCommonTranslation('CANCEL'),
			itemId : 'cancelBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
	}]
});