/**
 * Raghavendra.Soni
 */
Ext.define('Academia.view.examinationcenters.thesisManagement.FacultyThesisManagementFormWin',
		{
	extend : 'Ext.window.Window',
	alias : 'widget.facultythesismanagementformwin',
	title : getCommonTranslation('NOMINATE_STUDENT'),
	modal : true,
	maxHeight : 600,
	autoScroll : true,
	items : [ {
		xtype : 'dynamicfieldformwin',
		method : 'POST',
		itemId : 'thesismanagementItemId',
		autoScroll : true,
		margin : 0,
		layout : {
			type : 'vbox'
		},
		defaults : {
			labelAlign : 'top'
		},
		standardSubmit : false,
		plugins : "formlabelrequired",
		items : [{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'hidden',
				name : 'id'
			},
			{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
				name : 'academicTerm',
				itemId : 'academicTermId',
				displayField : 'value',
				valueField : 'id',
				typeAhead : false,
				forceSelection : true,
				hidden: false,
				allowBlank: false,
				store: Ext.create('Academia.store.common.AcademicTermByMappedFacultyVariantStore'),
				editable:false
			},{
				xtype: 'customcombobox',
				name: 'admission',
				itemId: 'admissionId',
				store: Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementFacultyPortalStudentStore'),
				fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
				valueField: 'secondId',
				displayField: 'value',
				queryParam:'name',
				disabled:true,
				minChars:3,
				typeAhead:false,
				allowBlank: false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				},
				labelStyle:'font-size:12px !important'
			}]
		},{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id',
			// width : '100%',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
				name : 'programId',
				itemId : 'programId',
				store:Ext.create('Academia.store.attendance.FacultyProgramBatchPeriodStore'),
				displayField:'valueCode',
				valueField:'id',
				width:226,
				typeAhead:true,
				disabled:true,
				forceSelection:true,
				allowBlank: false,
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				allowBlank: false,
				store: Ext.create('Academia.store.attendance.FacultyProgramBatchPeriodStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				editable:false
			},{
				xtype : 'hidden',
				name : 'period',
				itemId:'periodId',
			}]
		},{
			xtype : 'fieldcontainer',
			fieldLabel: getCommonTranslation('SUPERVISOR_ID_NAME')+': <font color=red>*</font>',
			itemId:'superVisorfieldcontainerId',
			layout : 'hbox',
			height:'auto',
			labelSeparator:'',
			style:{
				'margin-bottom': '-25px'
			},
			defaults : {
				labelAlign : 'top',
				width:'226'
			},
			items:[{
				xtype:'panel',
				itemId:'panelIdH',
				style:{
					'margin-left': '0px',
					'margin-top': '0px',
					'top':'0px'
				},
				items:[{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top',
						width:'226'
					},
					items:[{
						xtype: 'customcombobox',
						width: 226,
						name: 'superVisor',
						itemId:'superVisorId',
						store: 'common.AllUserBySmartSearch',
						valueField: 'id',
						displayField: 'value',
						queryParam:'codeOrName',
						allowBlank: false,
						typeAhead: false,
						rowIndx:0,
						minChars:3,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						forceSelection:true,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						}
					},{
						xtype: 'hidden',
						name: 'thesisManagementSupervisorId',
					},
					{
						xtype: 'button',
						itemId: 'addDetailedBtn',
						name: 'addDetailedBtn',
						width: 'auto',
						cls: 'CustomBodyBtnSettings',
						width: 'auto',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'3px'
						}
					}]
				}]
			}]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype: 'customcombobox',
					name: 'graduationCeremony',
					itemId:'graduationCeremonyId',
					fieldLabel : getCommonTranslation('GRADUATION_CEREMONY'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true,
					editable:false
				}, {
					xtype: 'customcombobox',
					name: 'thesisManagementDrool',
					itemId:'thesisManagementDroolId',
					fieldLabel : getCommonTranslation('DROOLS'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true,
					editable:false
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'textarea',
					name: 'remarks',
					itemId:'remarksId',
					fieldLabel: getCommonTranslation('REMARKS'),
					width:460,
					maxLength:1000

				}]
			},{
				xtype : 'fieldcontainer',
				cls : 'windowBtnPos',
				items : [
					{
						xtype : 'button',
						action : 'Submit',
						text : getCourseTxCommonTranslation('SAVE'),
						formBind : true,
						itemId : 'SubmitBtn',
						ui : 'CustomBtnSubmit',
						scale : CONSTANTS.BUTTONSIZE
					},
					{
						xtype : 'button',
						text : getCourseTxCommonTranslation('CANCEL'),
						ui : 'CustomBtnCancel',
						itemId : 'CancelBtn',
						scale : CONSTANTS.BUTTONSIZE
					} ]
			}]
	}]
		});