/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationtimetable.ExamTimetableGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.examtimetablegrid',
	title: (localStorage.getItem("portalId")==3) ? getMegaMenuTranslation('SP_EXAM_TIMETABLE') : getMegaMenuTranslation('PP_EXAM_TIMETABLE'),
			border: true,
			store:'examinationtimetable.ExamTimetableGridStore',
			viewConfig: {
				stripeRows: CONSTANTS.STRIPEROWS
			},
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'personinfostudentportal': (localStorage.getItem("portalId")==7) ? 7 : 3
				}
			},
			dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
					xtype: 'custompagingtoolbar',
					plugins:['pagesize'],
					store : 'examinationtimetable.ExamTimetableGridStore',
					emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo : true
				}]
			}],
			initComponent: function() {
				var grid=this;                   
				grid.addExportToolBarItems(grid);
				this.callParent(arguments);     
			},
			columns:[{
				header : getCommonTranslation('COURSE_CODE_NAME'),
				dataIndex : 'courseName',	  	
				flex:1,
				renderer:function(value,r,rec){
					return rec.get('courseCode') + '/' + rec.get('courseName');
				}
			},{
				header : getCommonTranslation('COURSE_VARIANT'),
				dataIndex : 'courseVariantName',
				flex:1,
				hidden: true
			},{
				header : getCommonTranslation('EVENT_NAME'),
				dataIndex : 'eventName',
				flex:1
			},{
				header : getExaminationTranslation('DATE'),
				dataIndex : 'formattedDate',
				flex:1 
				    
			},{
				header : getExaminationTranslation('TIME'),
				dataIndex : 'formattedTime',
				flex:1
			},{
				header : getExaminationTranslation('EVALUATION_PLAN'),
				dataIndex : 'planName',
				flex:1,
				hidden: true
			},
			{
				header : getExaminationTranslation('Building'),
				dataIndex : 'building',
				flex:1,
			},
			{
				header : getExaminationTranslation('RoomNumber'),
				dataIndex : 'roomNo',
				flex:1,
			},
			{
				header : getExaminationTranslation('ConcessionType'),
				dataIndex : 'concessionType',
				flex:1,
			},
			{
				header : getExaminationTranslation('ACCESS_PROVIDED'),
				dataIndex : 'isMapped',
				flex:1,
				renderer:function(value,r,rec){
					if(value){
						return getExaminationTranslation('YES');
					}else{
						return '';
					}
					
				}
			}]
});