/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show/take feedback about resources. 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceFeedBackWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.resourcefeedbackwindow',
    requires: ['Ext.selection.CellModel', 'Ext.grid.*'],
    title: getCommonTranslation('FEEDBACK'), //Feedback
    modal: true,
    resizable: false,
    autoScroll: true,
    height: (Ext.isIE8) ? 400 : '50%',
    width: (Ext.isIE8) ? 500 : '60%',
    items: [{
        xtype: 'grid',
        itemId: 'resourcefeedbackgrid',
        store: 'facilitiesresources.resourcebooking.ResourceFeedbackStore',
        title: getCommonTranslation('ASSIGNED_RESOURCES'), //Assigned Resources
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        selModel: {
            selType: 'cellmodel'
        },
        plugins: [
        Ext.create('Ext.grid.plugin.CellEditing', {
            clicksToEdit: 1
        })],        
        border: true,        
        columns: [{
            header: getCommonTranslation('RESOURCE_NAME'), //Resource Name
            dataIndex: 'resource',
            sortable : true,
            flex: .2,
            renderer: function(object) {
                return comboRender(object, 'name');
            }
        }, {
            header: getCommonTranslation('CATEGORY'), //Category
            dataIndex: 'resource',
            sortable : true,
            flex: .2,
            renderer: function(object) {
            	var category = comboRender(object, 'category');
                return getCommonTranslation(category);
            }
        }, {
            header: getCommonTranslation('GROUP'), //Group
            dataIndex: 'resource',
            sortable : true,
            flex: .2,
            renderer: function(object) {
                var category = comboRender(object, 'resourceGroup');
                return getCommonTranslation(category);
            }
        }, {
            header: getCommonTranslation('TYPE'), //Type
            dataIndex: 'resource',
            sortable : true,
            flex: .2,
            renderer: function(object) {
                var returnValue = "";
                if (object instanceof Object) {
                    if (object.resourceType instanceof Object) {
                        returnValue = comboRender(object.resourceType, 'value');
                    }
                    return returnValue;
                } else {
                    return returnValue;
                }
            }
        }, {
            header: getCommonTranslation('INDEPENDENT_ATTACHED'), //Independent Or Attached
            dataIndex: 'resource',
            sortable : true,
            flex: .3,
            renderer: function(object) {
                return comboRender(object, 'isDependent');
            }
        }, {
            header: getCommonTranslation('FEEDBACK'), //Feedback
            dataIndex: 'feedback',
            sortable : true,
            flex: .3,
            editor: {
                xtype: 'textareafield',
                name: 'feedback',
                emptyText: getCommonTranslation('ENTER_FEEDBACK'), //Enter feedback
                maxLength: 255,
                height:50,
                growMin:50,
                growMax:60
            },
            renderer: function(val) {
                if (isNullOrEmpty(val)) {
                    return getCommonTranslation('CLICK_HERE_TO_ENTER_FEEDBACK'); //click here to enter feedback
                } else {
                    return val;
                }

            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            itemId: 'btnSaveResourceFeedBack',
            text: getCommonTranslation('SAVE'), //Save
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'btnCancelResourceFeedBack',
            text: getCommonTranslation('CANCEL'), //Cancel
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});