/**
 *  @author Niklesh Tiwane
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.alumnieventregistrationdetailsgrid',
	title: getAlumni('EVENTS_REGISTRATION_DETAILS'),
	store : 'alumni.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsStore',
	//selType:'checkboxmodel',
	itemId: 'eventRegistrationDetailsGridItemId',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		//checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	border: true,
	refreshStoreData: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'alumni.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true,
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	columns: [{
		header : getAlumni('ALUMNI_NAME'),
		dataIndex : 'alumniName',
		flex:1
	},{
		header : getAlumni('ALUMNI_ID'),
		dataIndex : 'alumniCode',
		flex:1
	},{
		header : getAlumni('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex:1
	},{
		header : getAlumni('PROGRAM'),
		dataIndex : 'programName',
		flex:1,
	},{
		header : getAlumni('BATCH'),
		dataIndex : 'batchName',
		flex:1,
	},
	{
		header : getAlumni('REGISTRATION_DATE'),
		dataIndex : 'registrationDate',
		flex:1
	}]
});