/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.employeeresourcebookinggrid',
	store: 'facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingStore',
	title: getHostelTranslation("SEARCH_RESULT"),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'facilitiesresources.resourcebooking.employeePortal.EmployeeResourceBookingStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}],
	columns: [{
		header:  getCommonTranslation("EVENT_NAME"),
		dataIndex: 'eventName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("PURPOSE"),
		dataIndex: 'purpose',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("BOOKED_BY"),
		dataIndex: 'bookedBy',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("EVENT_DATE"),
		dataIndex: 'eventDate',
		flex:.1,
		sortable:true,
		
	},{
		header:  getCommonTranslation("FROM_TIME"),
		dataIndex: 'fromTime',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return timeRender(date);
		}
	},{
		header:  getCommonTranslation("TO_TIME"),
		dataIndex: 'toTime',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return timeRender(date);
		}
	},{
		header:  getFeeAndPaymentCommonTranslation("END_DATE"),
		dataIndex: 'endDate',
		flex:.1,
		sortable:true
	},{
		header:  getServiceRequestTranslation("VENUE"),
		dataIndex: 'venue',
		flex:.1,
		sortable:true
	}]
});
