/**
 * @author Ashwin Rawal
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.ServicewiseCaptureAttendanceSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.servicewisecaptureattendancesearch',
	plugins : "formlabelrequired",
	frame: false,
	border:false,
	autoScroll:false,
	method : 'POST',
	cls:'customSearchPanel',
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	items: [{
		xtype : 'hidden',
		name : 'id'
	},{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'service',
			itemId:'serviceId',
			fieldLabel : getProgramandcourseTranslation('SERVICE'),
			allowBlank: false,
			disabled:false,
			store: 'attendance.FacultyServiceStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
		},{
			xtype: 'multiselectcombofield',
			name: 'serviceBatch',
			itemId:'serviceBatchId',
			fieldLabel: getCourseTxCommonTranslation('PROGRAM_BATCH'),
			allowBlank: false,
			disabled:true,
			store: 'attendance.BatchByServiceStore',
			valueField: 'id',
			displayField: 'programBatchName',
			typeAhead:false,
			editable: false,
			forceSelection:true,
			autoSelect: false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			//cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}
		]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('DATE'),
				name : 'dateOfAttendance',
				itemId:'dateOfAttendance_Id',
				maxValue : new Date(),
				vtype : 'daterange',
				allowBlank: false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},
		{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype:'panel',
				itemId:'panelId',
				layout : 'vbox',
				width : 550,
				style:{
					marginLeft:'-10px',
					marginTop:'0px'
				},
				items:[{
					xtype : 'fieldcontainer',
					width: 'auto',
					itemId:'timeContainer',
					name:'timeContainer',
					hidden:true,
					layout : 'hbox',
					defaults : {
						labelAlign : 'top'
					},
					items : [{
						xtype : 'timefield',
						name : 'fromTime',		
						itemId : 'fromTime',			
						fieldLabel:getProgramandcourseTranslation('START_TIME'),
						format:'g:i A',
						increment: 1,
						vtype: 'timerange',
						width:100,
						allowBlank:false,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 1);
									obj.nextSibling().setMinValue(sDate);	
								}
							}
						}
					},{
						xtype : 'timefield',
						name : 'toTime',		
						itemId : 'toTime',			
						fieldLabel:getProgramandcourseTranslation('END_TIME'),
						format:'g:i A',
						vtype: 'timerange',
						increment: 1,
						width:100,
						allowBlank:false,
						listeners:{
							change:function(obj,val){
								if (!isNullOrEmpty(val)) {
									var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -1);
									obj.previousSibling().setMaxValue(eDate);
								}
							}
						}
					},{
						xtype : 'button',
						itemId: 'timeBtnAdd',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					}]
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				formBind : true,
				scale: CONSTANTS.BUTTONSIZE
			},

			{	xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
