/**
 *  @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.ManagePaymentPlanList', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managepaymentplanlist',
	store : 'feeandpayment.PaymentPlanListing',
	title: getFeeAndPaymentCommonTranslation('LIST_OF_PAYMENT_PLAN'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 headerFix:{
			headerFix: true,
			portalIdsWithStructure: {
				'managepaymentplanstructure':1
			}
		},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.PaymentPlanListing',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
         var grid=this;    
         grid.addExportToolBarItems(grid,false);
         this.callParent(arguments); 
  },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		disabled:true,
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		disabled:true,
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},
	{
		xtype : 'button',
		itemId : 'btnStudentEnrol',
		text : getCommonTranslation('STUDENT_ENROLLMENT'),
//		cls : 'CustomBtnCancel',
		scale : CONSTANTS.BUTTONSIZE,

	},{
		xtype : 'button',
		itemId : 'btnPlanEnrol',
		text : getFeeAndPaymentCommonTranslation('PLAN_ENROLLMENT'),
//		cls : 'CustomBtnCancel',
		disabled:true,
		scale : CONSTANTS.BUTTONSIZE,

	},{
		xtype : 'button',
		itemId : 'studentPaymentTransfer',
		text : getCommonTranslation('Transfer_Student_Payment_Plan'),
		disabled:true,
		scale : CONSTANTS.BUTTONSIZE,

	},
	{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('APPROVE'),
			itemId:'approveLink'	
		},{
			text:getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
			itemId:'doMappingLink'
		},{
			text:getFeeAndPaymentCommonTranslation('VIEW_UNMAPPED'),
			hidden:true,
			itemId:'viewUnmappedLink'
		},{
			text:getFeeAndPaymentCommonTranslation('VIEW_COVERAGE'),
			hidden:true,
			itemId:'viewCoverageLink'
		},{
			text:getFeeAndPaymentCommonTranslation('PAYMENT_TERM_SETTINGS'),
			itemId:'feePlanDoc'
		}],
		 listeners: { click: function() { this.showMenu(); } }
	},'->'],
	columns: [{
		header : getCommonTranslation('PAYMENTPLAN_ID'),
		dataIndex : 'paymentPlanId',
		flex:1
	},{
		header : getCommonTranslation('PAYMENTPLAN_NAME'),
		dataIndex : 'paymentPlanName',
		flex:1
	}/*,{
		header : getFeeAndPaymentCommonTranslation('VALID_TILL'),
		dataIndex : 'validTill',
		flex:1,
		hidden:true,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	}*/,{
		header : getCommonTranslation('APPROVAL_STATUS'),
		dataIndex : 'planStatus',
		flex:1,
		renderer : function(value){
			if(value=='ACTIVE'){
				return getCommonTranslation('ACTIVE');
			}else if(value=='INACTIVE'){
				return getCommonTranslation('INACTIVE');
			}else if(value=='PENDING'){
				return getCommonTranslation('PENDING');
			}
		}
	},{
		header : getCommonTranslation('MAPPING_STATUS'),
		dataIndex : 'mappingStatus',
		flex:1,
		renderer : function(value){
			if(value==null){
				return getCommonTranslation('UNMAPPED');
			}else if(value=='UNMAPPED'){
				return getCommonTranslation('UNMAPPED');
			}else if(value=='MAPPED'){
				return getCommonTranslation('MAPPED');
			}
		}
	},{
		header : getCommonTranslation('NO_OF_DOCUMENT'),
		dataIndex : 'documentCount',
		flex : 1,
		hidden:true,
		renderer:function(value){
			if(value>0){
				return  value;//'<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('REQUESTS_RECEIVED'),
		dataIndex : 'countOfWaitingAndEnrolledStudent',
		flex : 1,
		renderer:function(value){
			if(value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return 0;
			}
		}
	},{
		header : getCommonTranslation('START_DATE'),
		dataIndex : 'planStartDate',
		flex:1,
		hidden:true,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	},{

		header : getCommonTranslation('END_DATE'),
		dataIndex : 'planEndDate',
		flex:1,
		hidden:true,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
	
	}]
});