/**
 * @author Harsh.Nagra
 */

Ext.define('Academia.view.feeandpayment.PaymentPlanDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.paymentplandetailwin',
	title:getFeeAndPaymentCommonTranslation('PAYMENT_PLAN'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		formCode:'paymentPlanForm',
		itemId:'paymentplandetailformwin',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'paymentPlanId',
				itemId:'paymentPlanId',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_ID'),
				emptyText: getCommonTranslation('ID_AUTOGENERATE')
			},{
				xtype: 'textfield',
				name: 'paymentPlanName',
				itemId:'paymentPlanName',
				fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_NAME'),
				allowBlank:false,
				enforceMaxLength : true,
				maxLength:255,
				regex: /[a-zA-Z0-9]+/
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype : 'radiogroup',
					itemId:'inheritFromPaymentPlanId',
					labelAlign : 'top',
					allowBlank: false,
					fieldLabel:getFeeAndPaymentCommonTranslation('INHERIT_FROM_PAYMENT_PLAN'),
					items : [{
						boxLabel : getFeeAndPaymentCommonTranslation('YES'),
						name:'inheritFromPaymentPlan',
						inputValue : true,
					},{
						boxLabel : getFeeAndPaymentCommonTranslation('NO'),
						name:'inheritFromPaymentPlan',	
						inputValue : false,
						checked : true
					}]
				}]
				},{
					xtype: 'customcombobox',
					name: 'copyPaymentPlan',
					itemId:'copyPaymentPlanId',
					allowBlank:true,
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN'),
					store: 'feeandpayment.FindAllPaymentPlanStore',
					valueField: 'id',
					displayField: 'value',
					hidden:true,
					typeAhead:true,
					forceSelection:true,
					style:{'margin-left':'10px'}
					//style :{ margin:'12px 10px 25px 16px !important' }
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
	     	    
				xtype: 'numberfield',
				name: 'noOfInstallments',
				itemId:'noOfInstallments',
				fieldLabel: getFeeAndPaymentCommonTranslation('NO_OF_INSTALLMENTS'),
				hideTrigger:true,
	     	    mouseWheelEnabled:false,
	     	    allowDecimals:false,
	     	    regex: /[a-zA-Z0-9]+/,
				enforceMaxLength : true,
	     	    minValue:1,
	     	    maxLength: 36,
	     	   allowBlank: false
			},{
				xtype: 'customcombobox',
				name: 'currency',
				itemId:'currency',
				fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
				store: 'feeandpayment.FeeCurrencyStore',
				valueField: 'id',
				displayField: 'name',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
	     	    
				xtype: 'datefield',
				name: 'planStartDate',
				itemId:'planStartDate',
				fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				endDateField : 'planEndDate',
//				minValue:new Date(),
				editable:false,
				allowBlank: false
			},{
				xtype: 'datefield',
				name: 'planEndDate',
				itemId:'planEndDate',
				fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				startDateField : 'planStartDate',
				minValue:'planStartDate',
				editable:false,
				allowBlank: false
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'pymtPlanEnrolmentStartDate',
				itemId:'pymtPlanEnrolmentStartDate',
				allowBlank:false,
				width:226,
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				endDateField : 'pymtPlanEnrolmentEndDate',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('ENROLMENT_START_DATE')
			},{
				xtype: 'datefield',
				name: 'pymtPlanEnrolmentEndDate',				
				itemId:'pymtPlanEnrolmentEndDate',
				allowBlank:false,
				width:226,
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				startDateField : 'pymtPlanEnrolmentStartDate',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('ENROLMENT_END_DATE')
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				hidden:true,
				name: 'pymtPlanChangeFromDate',
				itemId:'pymtPlanChangeFromDateId',
				allowBlank:false,
				width:226,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				endDateField : 'pymtPlanChangeToDateId',
				vtype : 'daterange',
		       fieldLabel: getFeeAndPaymentCommonTranslation('CHANGE_FROM_DATE')
			},{
				xtype: 'datefield',
				name: 'pymtPlanChangeToDate',				
				itemId:'pymtPlanChangeToDateId',
				width:226,
				hidden:true,
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				startDateField : 'pymtPlanChangeFromDateId',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('CHANGE_TO_DATE')
			}]
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});