/**
 * @author SudarshanReddy
 */

Ext.define('Academia.view.feeandpayment.PaymentScheduleOneTimeWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.paymentscheduleonetimewin',
	title:getFeeAndPaymentCommonTranslation('PAYMENT_SCHEDULE_ONE_TIME'),
	autoScroll: true,
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight:600,
	items: [{
		xtype: 'form',
		//bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
    		xtype : 'datefield',
    		name : 'billingDate',
    		itemId : 'billingDate',
    		allowBlank:false,
    		fieldLabel: getFeeAndPaymentCommonTranslation('BILLING_DATE'),
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		},
    		//--submitFormat : CONSTANTS.DATE_FORMAT
			},{ 
				xtype: 'numberfield',
				name: 'dueDays',
				itemId:'dueDays',
				minValue:0,
				hideTrigger:true,
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('DUE_DAYS')
				//allowBlank:false
			},{
				xtype: 'datefield',
				name: 'dueDate',
				itemId:'dueDate',
				fieldLabel: getFeeAndPaymentCommonTranslation('DUE_DATE'),
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				editable:false
			},{ 
				xtype: 'numberfield',
				name: 'amount',
				itemId:'amount',
				minValue:1,
				hideTrigger:true,
				allowBlank:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT'),
				mouseWheelEnabled:false,
				allowDecimals:true,
				allowExponential:false
			},
			{
				xtype: 'multiselectcombofield',
				name: 'feeHeadIds',
				itemId:'feeHeadIds',
				fieldLabel: getFeeAndPaymentCommonTranslation('COPY_TO'),
				store: 'feeandpayment.OneTimeFeeHead',
				valueField: 'feeStageHeadConfigId',
				displayField: 'feeHeadName',
				allowBlank: true,
				typeAhead:true,		
	  			cls:'multiBrandCampusCls',
	  			typeAhead: true,
	            forceSelection: true,
	            listConfig: {
	                listeners: {
	                    beforeshow: function(picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code}' +
	                        '</div>';
	                }
	            }
			},{
				xtype: 'hidden',
				name: 'feeAmount',
				itemId:'feeAmount',
			},{	
			xtype:'fieldcontainer',
			//width:'100%',
		    cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'btnAdd',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});