/**
 * Bulk Doc Download
 * @author deepak.mathur
 */
Ext.define('Academia.view.feeandpayment.PaymentTermConfigurationWin', {
	extend : 'Ext.window.Window',
	alias : 'widget.paymenttermconfigurationwin',
	title: getFeeAndPaymentCommonTranslation('PAYMENT_TERMS_CONFIGURATION'),
	modal: true,
	resizable: true,
	autoScroll: true,
	frame: true,
	width: 630,
	minHeight: 450,
	//height: 450,
	maxHeight : 370,
	items : [{
		xtype : 'form',
		//height: 'auto',
		standardSubmit: false,
		autoScroll:true,
	    plugins: "formlabelrequired",
	    defaults:{
			labelAlign: 'top'
		},
		items : [{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
	    		xtype:'displayfield',
	    		value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('SELECTING_NEW_PAYMENT_TERM_MSG')+'</b>'/*,
	    		style: {
	    			textDecoration: "underline"
	    		}*/
	    	}]
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype: 'datefield',
				name: 'startDateNewPaymentTerm',
				itemId:'startDateNewPaymentTerm',
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				endDateField : 'endDateNewPaymentTerm',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE_OF_TERM_SELECTION')
			},{
				xtype: 'datefield',
				name: 'endDateNewPaymentTerm',
				itemId:'endDateNewPaymentTerm',
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				startDateField : 'startDateNewPaymentTerm',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE_OF_TERM_SELCTION')
			}]
		},
		{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
	    		xtype:'displayfield',
	    		value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('NEW_REGISTERED_PAYMENT_TERM_MESSAGE')+'</b>'/*,
	    		style: {
	    			textDecoration: "underline"
	    		}*/
	    	}]
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype: 'datefield',
				name: 'newRegisteredStudentStartDate',
				itemId:'newRegisteredStudentStartDate',
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				endDateField : 'newRegisteredStudentEndDate',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE_OF_TERM_SELECTION')
			},{
				xtype: 'datefield',
				name: 'newRegisteredStudentEndDate',
				itemId:'newRegisteredStudentEndDate',
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				startDateField : 'newRegisteredStudentStartDate',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE_OF_TERM_SELCTION')
			}]
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
	    		xtype:'displayfield',
	    		value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('CHANGING_NEW_PAYMENT_TERM_MESSAGE')+'</b>'/*,
	    		style: {
	    			textDecoration: "underline"
	    		}*/
	    	}]
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items:[{
				xtype: 'datefield',
				name: 'startDatePaymentTerm',
				itemId:'startDatePaymentTerm',
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				endDateField : 'endDatePaymentTerm',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE_OF_TERM_SELECTION')
			},{
				xtype: 'datefield',
				name: 'endDatePaymentTerm',
				itemId:'endDatePaymentTerm',
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				startDateField : 'startDatePaymentTerm',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE_OF_TERM_SELCTION')
			}]
		},{xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:456
			},
			items:[{
				xtype:'panel',
				items:[{
					xtype: 'paymenttermconfiguredocumentlistgrid',
					itemId:'paymenttermconfiguredocumentlistgridItemId',
					hidden:true,
					style : {
						marginLeft : '1px'
					}
				}]
			}]},{
    	xtype:'fieldcontainer',
        items: [{
				xtype: 'button',
				formBind: true,
				text : getCommonTranslation('SAVE'),
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE    			
        	},{
    			xtype : 'button',
    			text : getCommonTranslation('CANCEL'),
    			itemId : 'bulkDocCancel',
    			ui : 'CustomBtnCancel',
    			scale : CONSTANTS.BUTTONSIZE
    		},{
				xtype: 'button',
				text: getProgramandcourseTranslation('UPLOAD_DOCUMENT'),
				itemId: 'uploadDocument',
				ui: 'CustomBtnThird',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
    }]
});
