/**
 *  @author Amit G
 */


Ext.define('Academia.view.feeandpayment.ProjectedSponsorReportGrid', {
	//extend : 'Ext.grid.Panel',
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.projectedsponsorreportgrid',
	store : 'feeandpayment.FeeAndPaymentProjectedSponsorReportGridStore',
	 title: getFeeAndPaymentCommonTranslation('SPONSORSHIP_PROJECTED_INVOICES'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	frame:false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 features: [{
	        ftype: 'summary',
	        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.FeeAndPaymentProjectedSponsorReportGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
  },
	tbar: [],
	columns: [{
		header : getCommonTranslation('SPONSOR_Id'),
		dataIndex : 'sponsorshipCode',
		flex:1,
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(portalId!=3){
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
	      }
	},{
		header : getCommonTranslation('SPONSOR_NAME'),
		dataIndex : 'sponsorName',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_STUDENT'),
		dataIndex : 'admissionCount',
		flex:1,
		renderer : function(value,records) {
			if(value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getCommonTranslation('BILL_DATE'),
		dataIndex : 'billingDate',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		}
	},{
		header : getCommonTranslation('BILL_AMOUNT'),
		dataIndex : 'amount',
		flex : 1.8,
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("feeCurrencyId"));
			}
		}
		/*summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}*/
	}]
});
