/**
 * @author swapnil.patil
 */
Ext.define('Academia.view.feeandpayment.StudentAccountStatementSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentaccountstatementsearch',
	autoScroll: true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		width:'100%',
		cls:'customSearchPanel',
		items:[{
			xtype:'hidden',
			name:'id'
		},{
			xtype: 'radiogroup',
			itemId:'transactionTypeId',
			name: 'transactionTypeName',
			labelAlign:'top',			
			columns: 2,
			vertical: true,
			items: [
			        { itemId:'actualTransactionId', boxLabel: getFeeAndPaymentCommonTranslation('ACTUAL_TRANSACTION'), name: 'transactionType', inputValue:"ACTUAL_TRANSACTION",checked:true},
			        { itemId:'voucherTransactionId', boxLabel: getFeeAndPaymentCommonTranslation('VOUCHER_BASED_TRANSACTION'), name: 'transactionType', inputValue:"VOUCHER_BASED_TRANSACTION"}
			        ]
		    },{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_FROM'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(Ext.Date.add(new Date('2021-01-01')));
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				allowBlank:true,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_TO'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				allowBlank:true,
				vtype : 'daterange'
			}]	
		},{
			xtype: 'panel',
			style:{marginLeft:'-12px',marginBottom:'-5px'},
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	},{
		xtype : 'viewstudentaccountstatementgrid',
		itemId: 'viewstudentaccountstatementgrid',
		width:'100%',
		hidden:true
	},{
		xtype : 'viewstudentactualaccountstatementgrid',
		itemId: 'viewstudentactualaccountstatementId',
		width:'100%'
	}]
});