/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.feeandpayment.StudentProjectedBillingReportGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentprojectedbillingreportgrid',
	store : 'feeandpayment.dashboardAndReports.FeeAndPaymentReportGrid',
	title: getFeeAndPaymentCommonTranslation('PROJECTED_BILLING'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.dashboardAndReports.FeeAndPaymentReportGrid',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1,
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(portalId!=3){
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
		}
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'studentFirstName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'studentMiddleName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'studentLastName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1,
		summaryRenderer: function(value, summaryData, dataIndex) {
			if(portalId==3){
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
		}
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('FEE_PLAN'),
		dataIndex : 'feePlanName',
		flex:1
	},{
		header : getCommonTranslation('FEE_PLAN_RULE'),
		dataIndex : 'feePlanRule',
		flex:1
	},{
		header : getCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex : 1
	},{
		header : getCommonTranslation('BILLING_DATE'),
		dataIndex : 'billingDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('DUE_DATE'),
		dataIndex : 'dueDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('AMOUNT'),
		dataIndex : 'amount',
		flex : 1.8,
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("feeCurrencyId"));
			}
		}
	}]
});
