/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.accountingconfigurationmappingwin',
	title:getFeeAndPaymentCommonTranslation('ACCOUNTING_CONFIGURATION_MAPPING'),
	frame: true,
	modal:true,
	method: 'POST',
	maxHeight: 600,
	items: [{
		xtype: 'form',
		itemId:'accountingconfigurationmappingform',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			width:'auto',
			layout:'hbox',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'organizationUnit',
				itemId:'organizationUnit',
				fieldLabel: getFeeAndPaymentCommonTranslation('IAU'),
				store: 'feeandpayment.accountingConfigurationMapping.IAUAcademyLocationWise',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				allowBlank: false,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'accountConfig',
				itemId:'accountConfig',
				fieldLabel: getFeeAndPaymentCommonTranslation('ACCOUNT_CONFIGURATION_NAME'),
				store: 'feeandpayment.controlAccount.AccountConfigName',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true
			}]
		},{	
			xtype:'fieldcontainer',
			width:'auto',
			layout:'hbox',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items: [{
				xtype: 'datefield',
				name: 'startDate',
				itemId:'startDate',
				endDateField: 'tillDate',
				vtype: 'daterange',
				allowBlank:false,
				editable:false,
				fieldLabel: getFeeAndPaymentCommonTranslation('START_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT
			},{
				xtype: 'datefield',
				name: 'tillDate',
				itemId:'tillDate',
				allowBlank:false,
				editable:false,
				startDateField: 'startDate',
				vtype: 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('END_DATE'),
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
			}]
		},{
			xtype:'fieldcontainer',
			width:'auto',
			layout:'hbox',
			defaults: {
				labelAlign: 'top',
				width:226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'accountingYear',
				itemId:'accountingYear',
				fieldLabel: getFeeAndPaymentCommonTranslation('ACCOUNTING_YEAR_TYPE'),
				store: 'feeandpayment.accountingConfigurationMapping.AccountingYearType',
				valueField: 'id',
				displayField: 'accountingYearType',
				typeAhead:true,
				allowBlank: false,
				forceSelection:true
			},{
				xtype:'textfield',
				readOnly:true,
				name: 'currentAccountingYear',
				itemId:'currentAccountingYear',
				fieldLabel: getFeeAndPaymentCommonTranslation('CURRENT_ACCOUNTING_YEAR')
			}]
		},{
			xtype:'fieldcontainer',
			width:'auto',
			layout:'hbox',
			defaults: {
				labelAlign: 'top',
				width:226,
				xtype:'textfield',
				readOnly:true
			},
			items: [{
				name: 'companyCode',
				itemId:'companyCode',
				fieldLabel: getFeeAndPaymentCommonTranslation('COMPANY_CODE')
			},{
				name: 'companyIp',
				itemId:'companyIp',
				fieldLabel: getFeeAndPaymentCommonTranslation('COMPANY_IP')
			}]
		},{
			xtype:'fieldcontainer',
			width:'auto',
			layout:'hbox',
			defaults: {
				width: 226
			},
			items: [{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'whetherSubLedgerAccountingId',
					fieldLabel: getFeeAndPaymentCommonTranslation('SUB_LEDGER_LEVEL_POSTING'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getFeeAndPaymentCommonTranslation('YES'), name: 'whetherSubLedgerAccounting', inputValue: true},
					        { boxLabel: getFeeAndPaymentCommonTranslation('NO'), name: 'whetherSubLedgerAccounting', inputValue: false,checked:true}
					]
				}]
			},{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					labelAlign: 'top',
					itemId:'whetherSalesId',
					fieldLabel: getFeeAndPaymentCommonTranslation('BILL_TRANSACTION_TYPE'),
					columns: 2,
					vertical: true,
					items: [{ boxLabel: getFeeAndPaymentCommonTranslation('JV'), name: 'whetherSales', inputValue: false,checked:true},
					        { boxLabel: getFeeAndPaymentCommonTranslation('SALES'), name: 'whetherSales', inputValue: true}
					]
				}]
			}]
		},{ 	
			xtype:'fieldcontainer',
			width:'auto',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
