/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.addsequence.AddSequenceList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.addsequencelist',
	store : 'feeandpayment.SequenceList',
	cls:'feePlanRuleGridCls',
	  title : getCommonTranslation('FEE_PLAN_RULE_GRID'),
	border: true,
	 isGridConfigurable: true,
	 enableColumnHide: false,
	//cls:'horizontal-scrolling-fix', 
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.SequenceList',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('PERSON_COVERED'),
			itemId:'personCoveredLink'
		},{
			text:getFeeAndPaymentCommonTranslation('CONFIGURE_FEE_HEADS'),
			itemId:'configureFeeHeadsLink'
		}],
		 listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [/*{
		hidden:true,
		dataIndex:'id'
	},*/{
		header : getCommonTranslation('FEEPLAN_RULE'),
		dataIndex : 'feePlanSequence',
		flex : 1 
	},{
		header : getCommonTranslation('FEE_PLAN_RULE_DESCRIPTION'),
		dataIndex : 'feeRuleDesc',
		flex : 1	
	},{
		header : getCommonTranslation('STAGE_NAMES'),
		dataIndex : 'stageName',
		flex : 1	
	},{
		header : getCommonTranslation('PAYMENT_GROUP'),
		hidden : true,
		dataIndex : 'paymentGroup',
		flex : 1	 
	},{
		header : getCommonTranslation('PAYMENT_TERM'),
		hidden : true,
		dataIndex : 'paymentTerm',
		flex : 1 
	},{
		header : getCommonTranslation('FEE_PLAN_RULE_STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer : function(value){
			if(value=='ACTIVE'){
				return getFeeAndPaymentCommonTranslation('APPROVED_LABEL');
			}else if(value=='INACTIVE'){
				return getFeeAndPaymentCommonTranslation('INACTIVE_LABEL');
			}else if(value=='PENDING'){
				return getFeeAndPaymentCommonTranslation('UNAPPROVED_LABEL');
			}
		}
	},{
		header : getCommonTranslation('DOCUMENT_REQUIRED'),
		dataIndex : 'documentRequired',
		flex : 1,
		renderer:function(value){
			if(value==true){
				return getFeeAndPaymentCommonTranslation('YES');
			}else if(value==false){
				return getFeeAndPaymentCommonTranslation('NO');
			}
		}
	},{
		header : getCommonTranslation('FEEHEADS_COVERED'),
		dataIndex : 'feeHeadsCovered',
		flex : 1,
		renderer:function(value){
			if(value > 0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]
});