/**
 * @author priyanshi sharma

 */

var gridStore = Ext.create('Academia.store.feeandpayment.creditfeemapping.CreditFeeMappingRepeatGridStore');
Ext.define('Academia.view.feeandpayment.creditfeemapping.CreditFeeMappingRepeatTabGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.creditfeemappingrepeattabgrid',
	title: getFeeAndPaymentCommonTranslation('LIST_OF_QUALIFICATION_FOR_REPEAT_COURSES'),
	store:gridStore,
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'creditfeemappingsearchtab':1
		}},
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store:gridStore,
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'setDefaultAmountId',
		tooltip: getCommonTranslation('SET_DEFAULT_AMOUNT'),
		text:getCommonTranslation('SET_DEFAULT_AMOUNT'),
		disabled:true
		
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SAVE'),
			tooltip: getCommonTranslation('SAVE'),
			itemId: 'saveBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind :true,
			disabled:true
		}]
		
	}, {
		xtype: 'button',
		itemId: 'resetBtn',
		tooltip: getCommonTranslation('RESET'),
		text:getCommonTranslation('RESET'),
		disabled:true
		
	}],
	columns: [{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
	    sortable: false,
	   
	},{
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatTypeName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('PAYMENT_GROUP'),
		dataIndex: 'paymentGroupName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('PAYMENT_TERM'),
		dataIndex: 'paymentTermName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('AMOUNT_PER_CREDIT'),
		dataIndex: 'amountPerCredit',
		flex:.1,
	    sortable: false,
	    editor: {
	    	xtype: 'numberfield',
	    	maxLength:10,
	    	minValue:1,
	    	hideTrigger:true,
	    },
	    renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
	   
	}],
	 plugins: {
	        ptype: 'cellediting',
	        clicksToEdit: 1,
	    },
});
