/**
 * @author Rajkumar Patidar
 */
Ext.define('Academia.view.feeandpayment.dashboardAndReports.FeeAndPaymentCommonFilter', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.feeandpaymentcommonfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	border:false,
	method : 'POST',
	modal: true,
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	items: [{
		xtype:'hidden',
		name:'id'
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226,
			allowBlank:false
		},
		items:[{
			xtype: 'customcombobox',
			name: 'showStaticFor',
			itemId: 'showStaticFor',
			fieldLabel: getFeeAndPaymentCommonTranslation('SHOW_STATIC_FOR'),
			store:'feeandpayment.dashboardAndReports.FeeStaticsFor',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'showStaticView',
			itemId: 'showStaticView',
			fieldLabel: getFeeAndPaymentCommonTranslation('SHOW_STATIC_VIEW'),
			store:'feeandpayment.dashboardAndReports.FeeStaticsView',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'feePlanType',
			itemId:'feePlanType',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
			store: 'feeandpayment.FeePlanTypeStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype: 'customcombobox',
		name: 'feeUserType',
		itemId: 'feeUserType',
		fieldLabel: getFeeAndPaymentCommonTranslation('USER_TYPES'),
		store:'feeandpayment.dashboardAndReports.FeeUserType',
		displayField:'value',
		valueField:'id',
		typeAhead:true,
		forceSelection:true,
		hidden:true
	},{
		xtype: 'multiselectcombofield',
		name: 'programId',
		itemId: 'programId',
		autoloadStore: false,
		width:460,
		fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
		store:'facilitiesresources.resourcemaster.ProgramGridStore',
		displayField:'value',
		valueField:'id',
		typeAhead:true,
		forceSelection:true,
		//addAllSelector: true,
		//allSelector: true,
		maxLength:50000,
	},{	
		xtype: 'multiselectcombofield',
		name: 'batchId',
		fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
		itemId:'batchId',
		width:460,
		autoloadStore: false,
		store: 'program.programbatchdetail.BatchStore',//'enquiry.AcademicBatchStore',
		valueField: 'id',
		displayField: 'value',
		disabled:true,
		typeAhead:true,
		forceSelection:true
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			allowBlank:true
		},
		items:[{
			xtype: 'multiselectcombofield',
			name: 'feeHead',
			width:460,
			itemId:'feeHead',
			autoloadStore: false,
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_HEAD'),
			store: 'feeandpayment.dashboardAndReports.FeeHeadByFeePlanTypeId',
			valueField: 'id',
			displayField: 'value',
			maxLength:50000,
			typeAhead:true,
			forceSelection:true
		},{
			xtype : 'customcombobox',
			name : 'academicYear',
			itemId: 'academicYear',
			fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMIC_YEAR'),
			store : 'program.programDetails.programBatches.PrimaryAcademicStore',
			valueField : 'id',
			displayField : 'yearName',
			allowBlank : true,
			width:226
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'datefield',
			name: 'fromDate',
			itemId:'fromDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			editable:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE')
		},{
			xtype: 'datefield',
			name: 'tillDate',
			itemId:'tillDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			editable:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE')
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});