/**
 * @author Rajkumar.patidar
 */


Ext.define('Academia.view.feeandpayment.dashboardAndReports.paymentStatistics.PaymentStatisticsByProgramChart' ,{
	extend: 'Ext.chart.Chart',
    alias : 'widget.paymentstatisticsbycolumnchart',
    animate: true,
    shadow: true,
    mixins: {
        chartTitle: "Ext.chart.ChartTitle"
    },
    insetPadding: 20,
    initComponent: function() {
        var this$ = this;
        var numberField = !isNullOrEmpty(this.xAxesNumericField)?this.xAxesNumericField:'number';
        var categoryField = !isNullOrEmpty(this.yAxesCategoryField)?this.yAxesCategoryField:'category';
        var numericTitle = !isNullOrEmpty(this.xAxesNumericTitle)?this.xAxesNumericTitle: getCommonTranslation('NUMERIC_TITLE');
        var categoryTitle = !isNullOrEmpty(this.yAxesCategoryTitle)?this.yAxesCategoryTitle:getCommonTranslation('CATEGOTY_TITLE');
        //var columnWidth = !isNullOrEmpty(this.columnWidth)?this.columnWidth: REPORT_CONSTANTS.COMMON_COLUMN_WIDTH;
        var columnHeight = !isNullOrEmpty(this.columnHeight)?this.columnHeight: REPORT_CONSTANTS.COMMON_COLUMN_HEIGHT;
        var columnColor = !isNullOrEmpty(this.columnColor)?this.columnColor: REPORT_CONSTANTS.COMMON_COLOR;
        var chartStore = null;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store);
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['number', 'category'],
        		data: [{
        			number :0,
        			category : 'Category'
        		}]
        	});
        }
        Ext.apply(this$, {
        	store: chartStore,
            axes: [{
                type: 'Numeric',
              // position: 'left',
                position: 'bottom',
                fields: [numberField],
                label: {
                    //renderer: Ext.util.Format.numberRenderer('0,0')
                	renderer: function(value){
                		value = value.toString();
                		var lastThree = value.substring(value.length - 3);
                		var otherNumbers = value.substring(0, value.length - 3);
                		if(otherNumbers != '')
                		    lastThree = ',' + lastThree;
                		var result = otherNumbers.replace(/\B(?=(\d{2})+(?!\d))/g, ",") + lastThree;
                		var munFormater=Ext.util.Format.number(result,'0');
                		return munFormater;
                	}
                },
                title: numericTitle,
                grid: true,
                minimum: 0
               // decimals: 0,
               // majorTickSteps: 0
            }, {
                type: 'Category',
               // position: 'bottom',
                position: 'left',
                fields: [categoryField],
                title: categoryTitle
            }],
            series: [{
               // type: 'column',
                //axis: 'left',
            	type: 'bar',
                axis: 'bottom',
                xField: categoryField,
                yField: numberField,
                gutter : 40,
                highlight: false,
                tips: {
                  trackMouse: true,
                  //width: 200,
                  height: 28,
                  renderer: function(storeItem, item) {
                	  var tipTitle = storeItem.get(categoryField) + ': ' + storeItem.get(numberField);
                	  var titleLength = (tipTitle.length)*10;
                	  this.setWidth(titleLength);
                	  this.setTitle(tipTitle);
                	  item.sprite.el.dom.style.cursor="pointer";
                  }
                },
                style: {
                    'stroke-width': 0,
                    'stroke': '#fff'
                },
                renderer: function(sprite, record, attr, index, store) {
                	var color = CONSTANTS.CHART_COLORSET[index];
                	if(store.getCount() < 3){
                		return Ext.apply(attr, {
                            fill: color,
                            height: 30,
                            y: Math.max(attr.y, attr.y + (attr.height - 30) / 2)
                        });
                	}
                	else{
	                    return Ext.apply(attr, {
	                        fill: color
	                    });
                	}
                }
            }],
            listeners: {
                refresh: function(chart) {
                	var count = chart.getStore().getCount();
                	if(count>0){
                		var gutter = 40;
                		var chartHeight = (count * columnHeight)+ (count * gutter) + 80;
                		//var chartWidth = (count * columnWidth)+ (count * gutter) + 50;
                		//chart.setWidth(chartWidth);
                		//chart.setHeight(chartHeight);
                		chart.doComponentLayout();
                	}
                }
            }
        });
        this.mixins.chartTitle.initComponent.call(this);
        this$.callParent(arguments);
    },
    /*afterComponentLayout: function(width, height, oldWidth, oldHeight) {
    	if(this.getItemId() === "examDashBoardProgramBarChartItemId"){
	        this.callParent(arguments);
	        this.fireEvent('afterlayout', this);
        }
    }*/
});
