/**
 * @author Rajkumar.patidar
 */
var store = Ext.create('Ext.data.JsonStore', {
	  fields: ['name', 'data1'],
    data: [
           {'name':'MCA', 'data1':25000},
           {'name':'MBA', 'data1':25000},
           {'name':'MCM', 'data1':50000},
           {'name':'DILM', 'data1':75000},
           {'name':'ADBM', 'data1':50000},
           {'name':'ADIT', 'data1':100000}
    ]});

Ext.define('Academia.view.feeandpayment.dashboardAndReports.refundStatistics.RefundStatisticsByProgramChart' ,{
	extend: 'Ext.chart.Chart',
	requires: ['Ext.chart.*', 'Ext.Window', 'Ext.layout.container.Fit', 'Ext.fx.target.Sprite', 'Ext.window.MessageBox'],
    style: 'background:#fff',
    alias : 'widget.refundstatisticsbyprogramchart',
    animate: true,
    shadow: false,
    width: 350,
	height: 350,
    store: store,
    axes: [{
        type: 'Numeric',
        position: 'bottom',
        fields: ['data1'],
        label: {
            renderer: Ext.util.Format.numberRenderer('0,0')
        },
        title: getFeeAndPaymentCommonTranslation('STATISTICS_BY_PROGRAMS'),
        grid: true,
        minimum: 0
    }, {
        type: 'Category',
        position: 'left',
        fields: ['name']
    }],
    series: [{
        type: 'bar',
        axis: 'bottom',
        highlight: true,
        tips: {
          trackMouse: true,
          width: 140,
          height: 28,
          renderer: function(storeItem, item) {
            this.setTitle(storeItem.get('name') + ': ' + storeItem.get('data1') + ' views');
          }
        },
        label: {
          display: 'insideEnd',
            field: 'data1',
            renderer: Ext.util.Format.numberRenderer('0'),
            orientation: 'horizontal',
            color: '#333',
            'text-anchor': 'middle'
        },
        xField: 'name',
        yField: ['data1']
    }]

});
