/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.feeandpayment.discounts.AddDiscountApplicantSibilingGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.adddiscountapplicantsibilinggrid',
	title: getCommonTranslation('APPLICANT_SIBLING_DETAILS'),
	//store: 'student.studentenrollmentreport.StudentCurrentEnrollmentStore',
	border: true,
    refreshStoreData:true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		//emptyText :getCommonTranslation('EMPTY_MESSAGE'),
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			//store : 'student.report.StdDemographicReportGridStore',
			//emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header:  getFeeAndPaymentCommonTranslation('SIBLING_RELATION'),
		dataIndex: 'relationship',
		flex:.1,
	    sortable: false/*,
	    renderer:function(value, meta, record){
			if(record.data.isTotalRecord == true ){
				return '<b>'+value+'</b>';
			}else{
				return value;
			}
		}*/
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
	    sortable: false
	},{
		header:  getFeeAndPaymentCommonTranslation('DISCOUNT_GIVEN'),
		dataIndex: 'discountType',
		flex:.1,
	    sortable: false
	},{
		header:  getFeeAndPaymentCommonTranslation('PERCENTAGE_AMOUNT'),
		dataIndex: 'discountAmount',
		/*renderer:function(value, meta, record){
			if( value == 0 || value == '0' ){
				return '-';
			} else if(record.data.isTotalRecord == false ){
				return '<a href=#>'+value+'<a>';
			}else{
				return '<b>'+value+'</b>';
			}
		},*/
		flex:.1,
	    sortable: false
	},{
		header:  getFeeAndPaymentCommonTranslation('APPLICABLE_FROM'),
		dataIndex: 'applicableFrom',
		renderer:function(value, meta, record){
			return dateRender(value);
		},
		flex:.1,
	    sortable: false
	},{
		header:  getFeeAndPaymentCommonTranslation('APPLICABLE_TILL'),
		dataIndex: 'validTill',
		renderer:function(value, meta, record){
			return dateRender(value);
		},
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'studentDiscountStatus',
		flex:.1,
	    sortable: false
	}]
});
