/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.managebill.BillDiscountWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.billdiscountwindow',
	title:getFeeAndPaymentCommonTranslation('DISCOUNT'),
	frame: true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		bodyPadding: '0 0 0 0',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			    xtype:'hidden',
			    name:'id'
		    },{
		    	xtype:'hidden',
		    	itemId:'billFeePlanRuleStage',
		    	name:'billFeePlanRuleStage'
		    },{
				xtype: 'customcombobox',
				name: 'discountCode',
				itemId:'discountCode',
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),
				store:'feeandpayment.DiscountCode',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank:false,
				typeAhead:true
			},{
				xtype: 'numberfield',
				allowBlank:false,
				name: 'discountAmount',
				itemId:'discountAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_AMOUNT'),
				hideTrigger:true,
				mouseWheelEnabled:false,
				allowDecimals:true,
				regex: /[a-zA-Z0-9]+/,
				//enforceMaxLength : true,
				minValue:0,
				// maxLength: 20
			},{
	            xtype: 'datefield',
	            fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_DATE'),
	            allowBlank: false,
	            name: 'discountDate',
	            itemId : 'discountDate',
	          //--submitFormat : CONSTANTS.DATE_FORMAT,
	            listeners: {
	            	render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
	            	}
	            },
	            maxValue: new Date()
	        },{
	            xtype: 'customcombobox',
	            name: 'discountGivenBy',
	            itemId: 'cmbDiscountGivenBy',
	            //hidden:hiddenValue,
	            fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_GIVEN_BY'), //Select Program Gorup
	             //Select Program Gorup  
	            //labelWidth:150,
	            //width:220,
	            labelAlign: 'top',
	           // store:Ext.create('Academia.store.common.ActiveUsersByAcademyLocation'),
	            store:Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
	            valueField: 'id',
	            displayField: 'value',
	            editable: true,
	            queryMode: 'remote',
	            triggerAction: 'all',
	            //forceSelection: false,
	            queryParam:'name',
				minChars:3,
				allowBlank: false,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{code} / {value}'+ 
		                    '</div>';
		                }
		            }
	        },{
				xtype: 'textarea',
				name: 'reasonForDiscount',
				itemId:'reasonForDiscount',
				fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_REMARK')
		     },{
				xtype: 'fieldcontainer',
				//width:'100%',
				//cls:'windowBtnPos',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SAVE'),
					itemId: 'SubmitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind: true
				},{
					xtype: 'button',
					text: getCommonTranslation('CANCEL'),
					itemId: 'CancelBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
		     }]
	    }]     
});
