/**
 * @author Rajkumar
 * @author Sudarshan
 */
Ext.define('Academia.view.feeandpayment.managebill.BillHeaderPCSearchForm', {   
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias : 'widget.billheaderpcsearchform',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	defaults: {
		labelAlign: 'top',
		width:226
	},
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [
		{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: '50%',
				defaults: {
					width: '50%',
					labelAlign: 'top'
				},
				items : [{
		            xtype: 'multiselectcombofield',
		            name: 'fnpMultiBrandCampusNameManageBill',
		            itemId: 'fnpMultiBrandCampusManageBillId',
		            fieldLabel: getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
		            valueField: 'id',
					displayField: 'value',
					store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
		  			cls:'receiptHeaderMultiselect',
		  			typeAhead: true,
		  			allowBlank:false,
		            forceSelection: true,
		            listConfig: {
		                listeners: {
		                    beforeshow: function(picker) {
		                        picker.minWidth = picker.up('combobox').getSize().width;
		                    }
		                },
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{code}' +
		                        '</div>';
		                }
		            }
				}]
			},
		{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'billType',
			itemId:'billTypes',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_TYPE'),
			store:'feeandpayment.managebill.BillTypeForBill',
			valueField: 'id',
			displayField: 'value',
			queryMode: 'local',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'billView',
			itemId:'billViews',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_FOR'),
			store:'feeandpayment.managebill.BillForBill',
			valueField: 'value',
			//displayField: 'value',
			displayField: 'code',
			queryMode: 'local',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'raiseBillCategory',
			itemId:'raiseBillCategory',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_PAYABLE'),
			store: 'feeandpayment.managebill.BillCategory',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 460,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'thirdParty',
			itemId:'thirdParty',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('THIRD_PARTY'),
			store: 'feeandpayment.managebill.ThirdParties',
			valueField: 'id',
			displayField: 'firstName',
			queryParam:'codeOrPrintName',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,
			typeAhead:false,
			forceSelection:true,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{firstName} {lastName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'sponsors',
			itemId:'sponsors',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('SPONSOR'),
			store: 'feeandpayment.managebill.Sponsors',
			valueField: 'id',
			displayField: 'sponsorName',
			queryParam:'sponsorNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{sponsorshipCode}/{sponsorName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'applicant',
			itemId:'applicant',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT'),
			store: Ext.create('Academia.store.feeandpayment.managebill.Applicant'),
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'user',
			itemId:'userId',
			hidden:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('USER'),
			store: 'feeandpayment.managebill.User',
			valueField: 'id',
			displayField: 'nameToBePrinted',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{nameToBePrinted}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			hidden:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.StudentDetailsByNationalId'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			queryCaching: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'scholarship',
			itemId:'scholarship',
			hidden:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('SCHOLARSHIP'),
			store: 'feeandpayment.managebill.ScholarshipSmartSearch',
			valueField: 'id',
			displayField: 'scholarshipName',
			queryParam:'scholarshipNameOrCode',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			//minChars:3,
			//allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{scholarshipCode}/{scholarshipName}' +
					'</div>';
				}
			}
		},{

			xtype: 'customcombobox',
			name: 'billStatus',
			itemId:'billStatus',
			width: 226,
			fieldLabel: getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS'),
			store:'feeandpayment.managebill.BillStatus',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		}]

	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name: 'billDateForm',
			itemId:'billDateForm',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			vtype: 'daterange',
			endDateField: 'billDateTill',
			editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_FORM')
		},{
			xtype: 'datefield',
			name: 'billDateTill',
			itemId:'billDateTill',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			vtype: 'daterange',
			startDateField: 'billDateForm',
			editable:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DATE_TILL')
		},{
			xtype: 'customcombobox',
			name: 'invoiceOrCreditNoteNum',
			itemId:'invoiceOrCreditNoteNumId',
			fieldLabel: getFeeAndPaymentCommonTranslation('INVOICE_NUMBER'),
			store: 'feeandpayment.managebill.BillNumberStore',
			valueField: 'id',
			displayField: 'billNo',
			queryParam:'qry',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'checkboxfield',
			//width: 'auto',
			labelAlign: 'right',
			itemId:'whetherDeleted',
			boxLabel: getCommonTranslation('INCLUDE_CANCELED_BILL_RECORDS'),
			name: 'whetherDeleted',
			inputValue : true
		}/*,{
			xtype: 'checkboxfield',
			//width: 'auto',
			labelAlign: 'right',
			itemId:'flaggedBills',
			boxLabel: getFeeAndPaymentCommonTranslation('FLAGGED_BILLS'),
			name: 'flaggedBills',
			inputValue : true
		}*/,{
			xtype: 'multiselectcombofield',
			name: 'billLabel',
			itemId: 'billLabelId',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_LABEL'),
			valueField: 'id',
			displayField: 'value',
			store:'feeandpayment.managebill.BillLabelStore',
			cls:'receiptHeaderMultiselect',
			typeAhead: true,
			editable:false,
			forceSelection: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		style: {
			marginTop: '40px!important'
		},
		items:[{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'scholarshipStudent',
			itemId:'scholarshipStudent',
			hidden:true,
			disabled:true,
			width:460,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.ScholarshipStudent'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			//allowBlank:false,
			typeAhead:false,
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
        	xtype: 'customcombobox',
            name: 'programGroup',
            itemId:'programGroupItemId',
            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
            store:'program.ProgramGroupStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true
        }, {
        	xtype: 'customcombobox',
            name: 'programCategory',
            itemId:'programCategoryId',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
            store:'program.ProgramCategoryStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true
        },{
			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width:226,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
        },{
			xtype: 'multiselectcombofield',
			name: 'programId',
			//style:{marginTop:'10px'},
			width: 460,
			itemId: 'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			//store:'program.ProgramGroupStore',
			store:'common.ProgramForBillStoreFeePayment',
			displayField:'valueCode',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			hidden : false,
			maxLength:2000,
			cls:'receiptHeaderMultiselect',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
				

		}]
	},{
		    xtype:'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{ 
			xtype: 'multiselectcombofield',
			name: 'batchId',
			width: 460,
			itemId: 'batchId',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			store: 'feeandpayment.managebill.ManageBillBatchStore',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			disabled:true,
			hidden : false,
			maxLength:2000,
			cls:'receiptHeaderMultiselect'
		},{
			xtype: 'customcombobox',
			name: 'discountCode',
			itemId:'discountCode',
			fieldLabel: getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),
			store:'feeandpayment.DiscountCode',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			//allowBlank:false,
			typeAhead:true
		},{
			xtype: 'customcombobox',
			name: 'currency',
			width: 226,
			itemId:'currency',
			fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY'),
			store: 'feeandpayment.FeeCurrencyStore',
			valueField: 'id',
			displayField: 'name',
			typeAhead:true,
			forceSelection:true}]
	},{ 
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			labelAlign: 'top',
			width:226
		},
		items:[{
			xtype: 'datefield',
			name: 'billDueDateForm',
			itemId:'billDueDateForm',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			editable:false,
			vtype: 'daterange',
			endDateField: 'billDueDateTill',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DUE_DATE_FROM')
		},{
			xtype: 'datefield',
			name: 'billDueDateTill',
			itemId:'billDueDateTill',
			listeners: {
        	  render: function(field) {
        		  return dateFormatRender(field);
        	  }
          },
        //--submitFormat: CONSTANTS.DATE_FORMAT,
          	editable:false,
			vtype: 'daterange',
			startDateField: 'billDueDateForm',
			fieldLabel: getFeeAndPaymentCommonTranslation('BILL_DUE_DATE_TILL')
		},{
			xtype: 'customcombobox',
			name: 'admission',
			itemId: 'admissionId',
			fieldLabel: getFeeAndPaymentCommonTranslation('ROLL_NUMBER'),
			valueField: 'id',
			displayField: 'code',
			queryParam:'admissionCode',
			store:'feeandpayment.managebill.ManageBillRollNumber',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			queryCaching: false,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}
		},{
			xtype: 'checkboxfield',
			//width: 'auto',
			labelAlign: 'right',
			itemId:'inactiveStudentId',
			name: 'inactiveStudent',
			boxLabel: getFeeAndPaymentCommonTranslation('INACTIVE_STUDENT_ID'),
			inputValue : true,
			style:{
				marginTop:'25px !important'
			}
		},{
			xtype: 'checkboxfield',
			//width: 'auto',
			labelAlign: 'right',
			itemId:'inactiveAdmissionId',
			name: 'inactiveAdmission',
			boxLabel: getFeeAndPaymentCommonTranslation('INACTIVE_ADMISSION_ID'),
			inputValue : true,
			style:{
				marginTop:'25px !important'
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		hidden:true,
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'feePlanType',
			itemId:'feePlanType',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
			store: 'feeandpayment.FeePlanTypeStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'feePlan',
			itemId:'feePlan',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN'),
			store: 'feeandpayment.FeePlan',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'feeHead',
			itemId:'feeHead',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_HEAD'),
			store: 'feeandpayment.managebill.FeeStageConfigHead',
			valueField: 'id',
			displayField: 'feeHeadName',
			typeAhead:true,
			allowBlank: false,
			disabled:true,
			forceSelection:true
		}]
	}]
	},{
		xtype: 'panel',
		style:{marginLeft:'-12px',marginBottom:'-5px'},
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			formBind: true,
			disabled:false,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});