/**
 * @author Prakash Soni
 */
Ext.define('Academia.view.feeandpayment.payment.MedicalDetailsFormParent', {
    extend: 'Ext.form.Panel',
    alias: 'widget.medicaldetailsformparent',
    border: false,
    frame: true,
    collapsible: true,
    title: getPersonModuleTranslation('MD_MEDICAL_DETAILS'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'module',
        value: 'MedicalDetail'
    }, {
        xtype: 'hidden',
        name: 'medicalAidDocumentUploadPath'
    }, {
        xtype: 'hidden',
        itemId: 'documentIdItemId',
        name: 'documentId'
    }, {
        xtype: 'hidden',
        itemId: 'idItemId',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'scheme',
            itemId: 'schemeItemId',
            fieldLabel: getPersonModuleTranslation('MD_SCHEME'),
            allowBlank: false,
            maxLength: 255,
         	listeners: {
            	change: function(obj, newValue, oldValue, eOpts) {
            		var stc =  obj.up('medicaldetailsformparent');
            		var principleManberItems = stc.down('#principleMemberItemId');
            		var principleManberValue = principleManberItems.getValue();
            		var membershipNumberItems = stc.down('#membershipNumberItemId');
            		var membershipNumberValue = membershipNumberItems.getValue();
            		var stcMain = stc.up('studentregistrationtabstructure');
            		var medicalSubmitBtn = stcMain.down('#medicalDetailNextButtonId');
            		
            		var familyPractionerNameItemId = stc.down('#familyPractionerNameItemId');
            		var familyPractionerNameId = familyPractionerNameItemId.getValue();
            		
            		var familyPractionerCountryCodeItemId = stc.down('#familyPractionerCountryCodeItemId');
            		var familyPractionerCountryCodeId = familyPractionerCountryCodeItemId.getValue();
            		
            		var familyPractionerContactNumberItemId = stc.down('#familyPractionerContactNumberItemId');
            		var familyPractionerContactNumberId = familyPractionerContactNumberItemId.getValue();
            		
            		
            		if (!isNullOrEmpty(principleManberValue) && !isNullOrEmpty(membershipNumberValue) && !isNullOrEmpty(familyPractionerNameId) 
            			&&	!isNullOrEmpty(familyPractionerCountryCodeId) && !isNullOrEmpty(familyPractionerContactNumberId)	&& newValue) {
            			medicalSubmitBtn.setDisabled(false);
            		} else {
            			medicalSubmitBtn.setDisabled(true);
            		}
            	}
            }
            
        }, {
            xtype: 'textfield',
            name: 'option',
            itemId: 'optionItemId',
            fieldLabel: getPersonModuleTranslation('MD_OPTION'),
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'principleMember',
            itemId: 'principleMemberItemId',
            fieldLabel: getPersonModuleTranslation('MD_PRINCIPAL_MEMBER'),
            allowBlank: false,
            maxLength: 255,
            listeners: {
            	change: function(obj, newValue, oldValue, eOpts) {
            		var stc =  obj.up('medicaldetailsformparent');
            		var schemeItemIdItems = stc.down('#schemeItemId');
            		var schemeItemValue = schemeItemIdItems.getValue();
            		var membershipNumberItems = stc.down('#membershipNumberItemId');
            		var membershipNumberValue = membershipNumberItems.getValue();
            		var stcMain = stc.up('studentregistrationtabstructure');
            		var medicalSubmitBtn = stcMain.down('#medicalDetailNextButtonId');

            		var familyPractionerNameItemId = stc.down('#familyPractionerNameItemId');
            		var familyPractionerNameId = familyPractionerNameItemId.getValue();
            		
            		var familyPractionerCountryCodeItemId = stc.down('#familyPractionerCountryCodeItemId');
            		var familyPractionerCountryCodeId = familyPractionerCountryCodeItemId.getValue();
            		
            		var familyPractionerContactNumberItemId = stc.down('#familyPractionerContactNumberItemId');
            		var familyPractionerContactNumberId = familyPractionerContactNumberItemId.getValue();
            		
            		if (!isNullOrEmpty(schemeItemValue) && !isNullOrEmpty(membershipNumberValue) && !isNullOrEmpty(familyPractionerNameId) 
                			&&	!isNullOrEmpty(familyPractionerCountryCodeId) && !isNullOrEmpty(familyPractionerContactNumberId) && newValue) {
            			medicalSubmitBtn.setDisabled(false);
            		} else {
            			medicalSubmitBtn.setDisabled(true);
            		}
            	}
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'membershipNumber',
            itemId: 'membershipNumberItemId',
            fieldLabel: getPersonModuleTranslation('MD_MEMBERSHIP_NO'),
            allowBlank: false,
            maxLength: 255,
            listeners: {
            	change: function(obj, newValue, oldValue, eOpts) {
            		var stc =  obj.up('medicaldetailsformparent');
            		var principleMemberItemId = stc.down('#principleMemberItemId');
            		var principleMemberValue = principleMemberItemId.getValue();
            		var schemeItemIdItems = stc.down('#schemeItemId');
            		var schemeItemIdValue = schemeItemIdItems.getValue();
            		var stcMain = stc.up('studentregistrationtabstructure');
            		var medicalSubmitBtn = stcMain.down('#medicalDetailNextButtonId');
            		var familyPractionerNameItemId = stc.down('#familyPractionerNameItemId');
            		var familyPractionerNameId = familyPractionerNameItemId.getValue();
            		
            		var familyPractionerCountryCodeItemId = stc.down('#familyPractionerCountryCodeItemId');
            		var familyPractionerCountryCodeId = familyPractionerCountryCodeItemId.getValue();
            		
            		var familyPractionerContactNumberItemId = stc.down('#familyPractionerContactNumberItemId');
            		var familyPractionerContactNumberId = familyPractionerContactNumberItemId.getValue();

            		
            		if (!isNullOrEmpty(principleMemberValue) && !isNullOrEmpty(schemeItemIdValue) && !isNullOrEmpty(familyPractionerNameId) 
                			&&	!isNullOrEmpty(familyPractionerCountryCodeId) && !isNullOrEmpty(familyPractionerContactNumberId) && newValue) {
            			medicalSubmitBtn.setDisabled(false);
            		} else {
            			medicalSubmitBtn.setDisabled(true);
            		}
            	}
            }
        }, {
            xtype: 'datefield',
            name: 'validTill',
            itemId: 'validTillItemId',
            fieldLabel: getPersonModuleTranslation('VALIDTILL_DATE'),
            vtype: 'daterange',
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
                render: function(obj) {
                    obj = dateFormatRender(obj);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('MD_BLOOD_TYPE'),
            name: 'bloodType',
            itemId: 'bloodTypeItemId',
            store: 'enquiry.studentDetail.BloodGroupStore',
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'childDependentCode',
            itemId: 'childDependentCodeItemId',
            fieldLabel: getPersonModuleTranslation('MD_CHILD_DEPENDEND_CODE'),
            maxLength: 255
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'displayfield',
            value: '<b class="menu-title">' + getPersonModuleTranslation('MD_FAMILY_PRACTIONER_DETAILS') + '</b>'
        }]
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	//height: 100,
    	layout: 'hbox',
    	items: [{
    		xtype: 'textfield',
    		name: 'familyPractionerName',
    		itemId: 'familyPractionerNameItemId',
    		fieldLabel: getPersonModuleTranslation('NAME'),
    		//allowBlank:false,
    		maxLength: 255,
            listeners: {
            	change: function(obj, newValue, oldValue, eOpts) {
            		var stc =  obj.up('medicaldetailsformparent');
            		var principleMemberItemId = stc.down('#principleMemberItemId');
            		var principleMemberValue = principleMemberItemId.getValue();
            		var schemeItemIdItems = stc.down('#schemeItemId');
            		var schemeItemIdValue = schemeItemIdItems.getValue();
            		var stcMain = stc.up('studentregistrationtabstructure');
            		var medicalSubmitBtn = stcMain.down('#medicalDetailNextButtonId');
            		var membershipNumberItems = stc.down('#membershipNumberItemId');
            		var membershipNumberValue = membershipNumberItems.getValue();
            		
            		var familyPractionerCountryCodeItemId = stc.down('#familyPractionerCountryCodeItemId');
            		var familyPractionerCountryCodeId = familyPractionerCountryCodeItemId.getValue();
            		
            		var familyPractionerContactNumberItemId = stc.down('#familyPractionerContactNumberItemId');
            		var familyPractionerContactNumberId = familyPractionerContactNumberItemId.getValue();

            		
            		if (!isNullOrEmpty(principleMemberValue) && !isNullOrEmpty(schemeItemIdValue) && !isNullOrEmpty(membershipNumberValue) 
                			&&	!isNullOrEmpty(familyPractionerCountryCodeId) && !isNullOrEmpty(familyPractionerContactNumberId) && newValue) {
            			medicalSubmitBtn.setDisabled(false);
            		} else {
            			medicalSubmitBtn.setDisabled(true);
            		}
            	}
            }
    	}, {
    		xtype: 'customcombobox',
    		name: 'familyPractionerCountryCode',
    		itemId: 'familyPractionerCountryCodeItemId',
    		fieldLabel: getPersonModuleTranslation('MD_CONTACT_NO'),
    		valueField: 'isdCode',
    		displayField: 'isdCode',
    		allowBlank:false,
    		store: 'common.CountryStore',
    		triggerAction: 'all',
    		forceSelection: true,
    		minChars: 1,
    		//editable: false,
    		width: 80,
    		listeners: {
    			change: function(obj, newValue, oldValue, eOpts) {
            		var stc =  obj.up('medicaldetailsformparent');
            		var principleMemberItemId = stc.down('#principleMemberItemId');
            		var principleMemberValue = principleMemberItemId.getValue();
            		var schemeItemIdItems = stc.down('#schemeItemId');
            		var schemeItemIdValue = schemeItemIdItems.getValue();
            		var stcMain = stc.up('studentregistrationtabstructure');
            		var medicalSubmitBtn = stcMain.down('#medicalDetailNextButtonId');
            		var membershipNumberItems = stc.down('#membershipNumberItemId');
            		var membershipNumberValue = membershipNumberItems.getValue();

            		var familyPractionerContactNumberItemId = stc.down('#familyPractionerContactNumberItemId');
            		var familyPractionerContactNumberId = familyPractionerContactNumberItemId.getValue();

            		var familyPractionerNameItemId = stc.down('#familyPractionerNameItemId');
            		var familyPractionerNameId = familyPractionerNameItemId.getValue();

            		
            		if (!isNullOrEmpty(principleMemberValue) && !isNullOrEmpty(schemeItemIdValue) && !isNullOrEmpty(membershipNumberValue) 
                			&&	!isNullOrEmpty(familyPractionerContactNumberId) && !isNullOrEmpty(familyPractionerNameId) && newValue) {
            			medicalSubmitBtn.setDisabled(false);
            		} else {
            			medicalSubmitBtn.setDisabled(true);
            		}
            	}
            }    		
    	}, {
    		xtype: 'numberfield',
    		name: 'familyPractionerContactNumber',
    		itemId: 'familyPractionerContactNumberItemId',
    		minLength: 0,
    		maxLength: 11,
    		enforceMaxLength: true,
    		allowBlank:false,
    		hideTrigger: true,
    		keyNavEnabled: false,
    		mouseWheelEnabled: false,
    		allowExponential: false,
    		width: 146,
    		style:{
    			marginTop:'28px'
    		},            
    		listeners: {
            	change: function(obj, newValue, oldValue, eOpts) {
            		var stc =  obj.up('medicaldetailsformparent');
            		var principleMemberItemId = stc.down('#principleMemberItemId');
            		var principleMemberValue = principleMemberItemId.getValue();
            		var schemeItemIdItems = stc.down('#schemeItemId');
            		var schemeItemIdValue = schemeItemIdItems.getValue();
            		var stcMain = stc.up('studentregistrationtabstructure');
            		var medicalSubmitBtn = stcMain.down('#medicalDetailNextButtonId');
            		var membershipNumberItems = stc.down('#membershipNumberItemId');
            		var membershipNumberValue = membershipNumberItems.getValue();
            		var familyPractionerCountryCodeItemId = stc.down('#familyPractionerCountryCodeItemId');
            		var familyPractionerCountryCodeId = familyPractionerCountryCodeItemId.getValue();
            
            		var familyPractionerNameItemId = stc.down('#familyPractionerNameItemId');
            		var familyPractionerNameId = familyPractionerNameItemId.getValue();

            		
            		if (!isNullOrEmpty(principleMemberValue) && !isNullOrEmpty(schemeItemIdValue) && !isNullOrEmpty(membershipNumberValue) 
                			&&	!isNullOrEmpty(familyPractionerCountryCodeId) && !isNullOrEmpty(familyPractionerNameId) && newValue) {
            			medicalSubmitBtn.setDisabled(false);
            		} else {
            			medicalSubmitBtn.setDisabled(true);
            		}
            	}
            }
    	}]
    }, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
	        xtype: 'filefield',
	        name: 'file',
	        itemId: 'medicalAidDocumentItemId',
	        fieldLabel: getPersonModuleTranslation('MD_MEDICAL_AID_DOCUMENT'),
	        buttonText: getPersonModuleTranslation('BROWSE'),
	        ui: 'CustomBtnSubmit',
	        width: 226,
	        labelAlign: 'top',
	        listeners: {
	            specialkey: function(me, e) {
	                if (e.getKey() == e.TAB) {
	                    e.stopEvent();
	                }
	            }
	        }
	    }, {
	    	xtype: 'displayfield',
	        itemId: 'availableDocumentLabelItemId',
	        value: '<a href=#>' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</a>',
	        hidden: true,
	        style: {
	            marginTop: '24px',
	            textDecoration: "underline"
	        }
		}]
	},{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('NEXT'),
            itemId: 'medicalDetailNextButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }]
    }]
});