/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.feeandpayment.receipts.FeeLedgerMasterWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.feeledgermasterwin',
	title:getFeeAndPaymentCommonTranslation('FEE_LEDGER'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		itemId:'feeledgermasterform',
		bodyPadding: '0 20 0 0',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
				width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'textfield',
			name: 'ledgerName',
			itemId:'ledgerName',
			fieldLabel: getFeeAndPaymentCommonTranslation('LEDGER_NAME'),
		    allowBlank:false
		},{
			xtype: 'customcombobox',
			name: 'academyId',
			itemId:'academyId',
			fieldLabel: getFeeAndPaymentCommonTranslation('ACADEMY'),
			store: 'common.AcademyStore',
			valueField: 'id',
			displayField: 'value',
            editable: false,
			forceSelection:true,
			 allowBlank:false
		},{
			xtype: 'customcombobox',
			name: 'locationId',
			itemId:'locationId',
			fieldLabel: getFeeAndPaymentCommonTranslation('LOCATION'),
			store: 'common.AcademyLocationByAcademyId',
			valueField: 'id',
			displayField: 'locationName',
            editable: false,
			forceSelection:true,
			 allowBlank:false
		},{
			  xtype:'fieldcontainer',
	    	  width:'100%',
	    	  cls:'windowBtnPos',
			  items: [{
			    	 xtype: 'button',
					 action: 'Submit',
					 text: getFeeAndPaymentCommonTranslation('SAVE'),
					 formBind: true,
					 itemId: 'SubmitBtn',
					 ui: 'CustomBtnSubmit',
					 scale: CONSTANTS.BUTTONSIZE
			       },{
					 xtype: 'button',
					 text: getFeeAndPaymentCommonTranslation('CANCEL'),
					 ui: 'CustomBtnCancel',
					 itemId: 'CancelBtn',
					 scale: CONSTANTS.BUTTONSIZE
			      }]
	       }]
		}]	
});