/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.receipts.ReceiptInstrumentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.receiptinstrumentgrid',
	store : 'feeandpayment.receipts.ReceiptInstrumentTempStore',
	title : getFeeAndPaymentCommonTranslation('INSTUMENT_DETAILS'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
		
		header : getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
		dataIndex : 'paymentMode',
		flex : 1,
		renderer:function(val){
    		 if(val){
			     return val.value;
    		 }
		 }
	},{
		header : getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
		dataIndex : 'instrumentNo',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE'),
		dataIndex : 'instrumentDate',
		flex : 1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getFeeAndPaymentCommonTranslation('AMOUNT'),
		dataIndex : 'amount',
		flex : 1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			return currencyRenderer(value,record.get("currencyId"));
		}
	},{
    	 header : getFeeAndPaymentCommonTranslation('DRAWN_ON_BANK'),
     	 dataIndex : 'instrumentBank',
     	 flex : 1,
     	 renderer:function(val){
     		 if(val){
			     return val.value;
     		 }
     		 else{
     			 return 'Others';
     		 }
		 }
     }]
});