/**
 * @author Ranga
 */
Ext.define('Academia.view.feeandpayment.reports.ApplicantFeeHeadBasedCollectionReportGrid', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicantfeeheadbasedcollectionreportgrid',
	store : 'feeandpayment.reports.ApplicantFeeHeadBasedReportStore',
	title : getFeeAndPaymentCommonTranslation('APPLICANT_FEE_HEAD_BASED_COLLECTION_REPORT'),
	border : true,
	width : 1500,
	autoScroll : false,
	refreshStoreData : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features : [ {
		ftype : 'summary',
		showSummaryRow : CONSTANTS.SHOW_SUMMARY_ROW
	} ],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			store : 'feeandpayment.reports.ApplicantFeeHeadBasedReportStore',
			emptyMsg : getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	initComponent : function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	columns : [{
	        	   header : getFeeAndPaymentCommonTranslation('APPLICATION_ID'),
	        	   dataIndex : 'applicationCode',
	        	   flex : 1,
	        	   /*summaryRenderer : function(value, summaryData,
	        			   dataIndex) {
	        		   return getFeeAndPaymentCommonTranslation('TOTAL');
	        	   }*/
	        	   summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
						if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
						// a = currencyRenderer('',store.data.items[0].data.acadLocBaseCurrencyId).split(" ");
							return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
						}
						else {
							return getFeeAndPaymentCommonTranslation('TOTAL');
						}
					}
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('APPLICANT_NAME'),
	        	   dataIndex : 'printName',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('PROGRAM'),
	        	   dataIndex : 'programName',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('BATCH'),
	        	   dataIndex : 'batchName',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
	        	   dataIndex : 'seatName',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('TOTAL_AMOUNT'),
	        	   dataIndex : 'totalBillAmount',
	        	   flex : 1,
	        	   summaryType : 'sum',
	        	   align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	   renderer : function(value, metaData, record,
	        			   row, col, store, gridView) {
	        		   if (!isNullOrEmpty(record.get("currencyId"))) {
	        			   return currencyRenderer(value, record
	        					   .get("currencyId"));
	        		   }
	        	   },
	        	   /*summaryRenderer : function(value, summaryData,
	        			   dataIndex, rowIndex, colIndex, store,
	        			   view) {
	        		   return value;
	        	   }*/
	        	   summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
						if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
							return currencyRenderer(value,store.data.items[0].data.currencyId);
						}
						else {
							return value;
						}
					}
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('BILL_AMOUNT_PAID'),
	        	   dataIndex : 'settledAmount',
	        	   flex : 1,
	        	   summaryType : 'sum',
	        	   align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	   renderer : function(value, metaData, record,
	        			   row, col, store, gridView) {
	        		   if (!isNullOrEmpty(record.get("currencyId"))) {
	        			   return currencyRenderer(value, record
	        					   .get("currencyId"));
	        		   }
	        	   },
	        	  /* summaryRenderer : function(value, summaryData,
	        			   dataIndex, rowIndex, colIndex, store,
	        			   view) {
	        		   return value;
	        	   }*/
	        	   summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
						if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
							return currencyRenderer(value,store.data.items[0].data.currencyId);
						}
						else {
							return value;
						}
					}
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('OUT_STANDING'),
	        	   dataIndex : 'totalOutstandingAmount',
	        	   flex : 1,
	        	   summaryType : 'sum',
	        	   align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	   renderer : function(value, metaData, record,
	        			   row, col, store, gridView) {
	        		   if (!isNullOrEmpty(record.get("currencyId"))) {
	        			   return currencyRenderer(value, record
	        					   .get("currencyId"));
	        		   }
	        	   },
	        	   /*summaryRenderer : function(value, summaryData,
	        			   dataIndex, rowIndex, colIndex, store,
	        			   view) {
	        		   return value;
	        	   }*/
	        	   summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
						if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
							return currencyRenderer(value,store.data.items[0].data.currencyId);
						}
						else {
							return value;
						}
					}
	           }]
});
