/**
 * @author Priyanshi Sharma
 */
 
Ext.define('Academia.view.feeandpayment.siblingranking.SiblingRankingDetailsWindow',{
	extend:'Ext.window.Window',
	alias: 'widget.siblingrankingdetailswindow',
	title: getFeeAndPaymentCommonTranslation('SIBLING_DETAILS'),
	frame: true,
	autoScroll:true,
	modal:true,
	maxHeight:700,
	method: 'POST',
    items: [{
        xtype: 'hidden',
        itemId: 'sibling_hidden_field',
        name: 'id'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId: 'siblingIdSearchItemField',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			name: 'parentNational',
			itemId: 'parentNationalId',	
			fieldLabel: getFeeAndPaymentCommonTranslation('PARENT_NATIONAL_ALERNATE_ID'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			allowBlank: false,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listeners: {
				render: function(combo) {
                    var store = Ext.create('Academia.store.feeandpayment.managebill.Student');
                    combo.bindStore(store);
                }
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
        },{
            xtype: 'button',
            text: getFeeAndPaymentCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            ui: 'CustomBtnSubmit',
            style: {
                marginTop: '30px'
            },
            scale: CONSTANTS.BUTTONSIZE
        }]
    },{
    	xtype:'siblingrankingdetailspopupgrid',
    	itemId:'siblingRankingDetailsPopupGridId',
    	maxHeight: 600,
    	width:900
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getFeeAndPaymentCommonTranslation('LINK_AND_SAVE'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getFeeAndPaymentCommonTranslation('UPDATE_RANKING'),
            itemId: 'linkSaveBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            hidden:true,
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});