/**
 * @author Narendra Jain
 */
 
Ext.define('Academia.view.feeandpayment.siblingranking.SiblingRankingGrid',{
	extend:'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias:'widget.siblingrankinggrid',	
	store : 'feeandpayment.siblingranking.SiblingRankingGridStore', 
	title : getFeeAndPaymentCommonTranslation('SIBLING_RANKING'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.siblingranking.SiblingRankingGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentId',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_SURNAME'),
		dataIndex : 'studentSurname',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ACADEMY_LOCATION'),
		dataIndex : 'studentAcademyLocation',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'program',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('SIBLING_RANKING'),
		dataIndex : 'siblingRanking',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('PARENT_1_NATIONAL_ALTERNATE_ID'),
		dataIndex : 'siblingRanking',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('PARENT_2_NATIONAL_ALTERNATE_ID'),
		dataIndex : 'siblingRanking',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('PARENT_3_NATIONAL_ALTERNATE_ID'),
		dataIndex : 'siblingRanking',
		flex : 1
	}]
});