/**
 * @author bhanu ps
 */
Ext.define('Academia.view.filemanagement.FileAcademyLocationsWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.fileacademylocationswindow',
	title:getCommonTranslation('ACADEMY_LOCATION'),
	frame: true,
//	autoScroll:true,
	modal:true,
	method: 'POST',
	maxHeight:500,
	width: '40%',
	height:'60%',
	padding:'10 10 10 10',
	items: [{
			 xtype: 'grid',
		     autoScroll:true,
		     name:'alGrid',
		     itemId:'alGridItemId',
		     frame:false,
		     border:true,
		     store: 'leavemanagement.EligibilityALGridStore',
	         maxHeight:300,
	         hideHeaders :false,
	         width: '96%',
	         style:{
	        	marginBottom:'5px',
	         },
	         viewConfig: {
	             stripeRows: false
	         },
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	         columns: [{
		        header: getCommonTranslation('ACADEMY_LOCATION'),
		        dataIndex: 'value',
		        flex:.2,
		        sortable: true,
		       /* renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
							return record.data.value+" "+record.data.code; 
					}                        
				}*/
		    }]
	    },{
			 xtype: 'grid',
		     autoScroll:true,
		     name:'attributeGrid',
		     itemId:'attributeGrid',
		     hidden:true,
		     frame:false,
		     border:true,
		    // store: 'leavemanagement.EligibilityALGridStore',
	         maxHeight:300,
	         hideHeaders :false,
	         width: '96%',
	         tbar: [{
	        	 xtype: 'button',
	        	 itemId: 'btnDelete',
	        	 cls: 'CustomToolbarBtnReject',
	        	 tooltip: getCommonTranslation('DELETE'),
	        	  iconCls: 'icon-Delete',
					cls:'iconDelete'
	         }],
	         style:{
	        	marginBottom:'5px',
	         },
	         viewConfig: {
	             stripeRows: false
	         },
	         selModel: {
	    	     checkOnly : true, 
	    	     allowDeselect: false
	        },
	         columns: [{
		        header: getCommonTranslation('ATTRIBUTE_VALUE'),
		        dataIndex: 'value',
		        flex:.2,
		        sortable: true,
		        renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
							return record.data.value+" "+record.data.code; 
					}                        
				}
		    }]
	    }]	
});