/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.filemanagement.ManageAssignedFilesGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.manageassignedfilesgrid',
	store: 'filemanagement.ManageFileAssignedGridStore',
	title: getFileManagementTranslation('LIST_OF_ASSIGNED_FILES'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'filemanagement.ManageFileAssignedGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		text: getFileManagementTranslation('FORWARD_FILE'),
		itemId: 'forwardFile',
	},{
		xtype: 'button',
		text: getFileManagementTranslation('UPLOAD_DOCUMENT'),
		itemId: 'uploadDocument',
		buttonAlign: 'left',
	}],
	columns: [{
		header:  getServiceRequestTranslation('ID'),
		dataIndex: 'id',
		flex:.8,
		sortable:true,
		hidden:true
	},{
		header:  getServiceRequestTranslation('FILE_TYPE'),
		dataIndex: 'fileType',
		flex:.8,
		sortable:true
	},{
		header:  getServiceRequestTranslation('FILE_NO'),
		dataIndex: 'fileNumber',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.fileNumber)){
				return '<a href=#>'+record.data.fileNumber+'</a>';
			}else{
				return '-';
			}
		},
		sortable:true
	},{
		header:  getServiceRequestTranslation('TITLE')+'/'+getServiceRequestTranslation('SUBJECT'),
		dataIndex: 'fileSubject',
		flex:1,
		sortable:true
	},{
		header: getFileManagementTranslation('ACADEMY_LOCATIONS'),
		dataIndex: 'academyLocations',
		flex:1,
		sortable: true,
		renderer:function(value,meta,record){
			if(value.length >0){
				return '<a href=#>'+value.length+'</a>';
			}else{
				return 0;
			}
		}
	},{
		header:  getServiceRequestTranslation('CREATION_DATE'),
		dataIndex: 'creationDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getServiceRequestTranslation('PRIORITY'),
		dataIndex: 'priority',
		flex:.8,
		sortable:true
	},{
		header:  getServiceRequestTranslation('ATTACHMENTS'),
		dataIndex: 'attachments',
		flex:1,
		sortable:true,

		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.attachments)) {
				if(record.data.attachments.length>1) {
					return '<a href=#>'+record.data.attachments.length+'<a>';
				} else if(record.data.attachments.length==1) {
					return '<a href=#>'+record.data.attachments[0].value+'<a>';
				} else{
					return '0';
				}
			}                        
		}

	},{
		header:  getFileManagementTranslation('ACKNOWLEDGMENT_STATUS'),
		dataIndex: 'acknowledgement',
		flex:1.5,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.acknowledgement)) {
				return getCommonTranslation(value);
			} else {
				return value;
			}
		}
	},{
		header:  getFileManagementTranslation('RECEIVED_DATE'),
		dataIndex: 'receivedDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getFileManagementTranslation('FILE_HANDOVER_BY'),
		dataIndex: 'fileHandoverByName',
		flex:1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('DUE_DATE'),
		dataIndex: 'dueDate',
		flex:1,
		sortable:true,
		renderer: function(date) {
			return dateRender(date);
		}
	}]
});
