/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.filemanagement.ManageFilesGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.managefilesgrid',
	store: 'filemanagement.ManageFileGridStore',
	title: getFileManagementTranslation('LIST_OF_FILES'),
	border: true,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'managefilesearchstructure':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'filemanagement.ManageFileGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getFileManagementTranslation('ASSIGN_TO'),
			itemId: 'btnAssignTo',
		},{
			text:getFileManagementTranslation('UPDATE_STATUS'),
			itemId:'btnUpdateStatus'
		},{
			text:getFileManagementTranslation('UPLOAD_DOCUMENT'),
			itemId:'btnUploadDocument'
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header:  getServiceRequestTranslation('FILE_TYPE'),
		dataIndex: 'fileType',
		flex:.8,
		sortable:true
	},{
		header:  getServiceRequestTranslation('FILE_NO'),
		dataIndex: 'fileNumber',
		flex:1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('TITLE')+'/'+getServiceRequestTranslation('SUBJECT'),
		dataIndex: 'fileSubject',
		flex:1,
		sortable:true
	},{
		header: getFileManagementTranslation('ACADEMY_LOCATIONS'),
		dataIndex: 'academyLocationCount',
		flex:.8,
		sortable: true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.academyLocations)) {
				if(record.data.academyLocations.length==0){
					return value;  
				} else {
					return '<a href=#>'+record.data.academyLocations.length+'</a>';
				}
			} else {
				return "-";   
			} 
		}
	},{
		header:  getServiceRequestTranslation('FILE_OWNER'),
		dataIndex: 'fileOwner',
		flex:1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('CREATION_DATE'),
		dataIndex: 'creationDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getServiceRequestTranslation('DUE_DATE'),
		dataIndex: 'dueDate',
		flex:1,
		sortable:true,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header:  getServiceRequestTranslation('FILE_GROUP'),
		dataIndex: 'fileGroup',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getServiceRequestTranslation('PRIORITY'),
		dataIndex: 'priority',
		flex:.8,
		sortable:true
	},{
		header:  getServiceRequestTranslation('FILE_LOCATION'),
		dataIndex: 'filePath',
		flex:1,
		sortable:true,
		renderer:function(){
			return "<a href='#'>"+getExaminationTranslation('VIEW')+"</a>";
		}
	},{
		header:  getFileManagementTranslation('ACKNOWLEDGMENT_STATUS'),
		dataIndex: 'acknowledgement',
		hidden:true,
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return record.data.acknowledgement;
			}
		}
	},{
		header:  getServiceRequestTranslation('FILE_STATUS'),
		dataIndex: 'currentStatus',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			} else {
				return value;
			}
		}
	},{
		header:  getServiceRequestTranslation('ATTACHMENTS'),
		dataIndex: 'attachments',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.attachments)) {
				if(record.data.attachments.length>1) {
					return '<a href=#>'+record.data.attachments.length+'<a>';
				} else if(record.data.attachments.length==1) {
					return '<a href=#>'+record.data.attachments[0].value+'<a>';
				} else{
					return '0';
				}
			}                        
		}
	}]
});
