/**
 * @author Pankaj Sisodiya
 * 
 */
Ext.define('Academia.view.hostel.hostelApplicationSetup.HostelApplicationSetupFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.hostelApplicationSetupFilter',
	autoScroll:false,
	frame:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{

				xtype: 'customcombobox',
				name:'userType',
				store: Ext.create('Ext.data.Store', {
					fields: ['id', 'name'],
					data : [
						{"id":"ALL", "name":getCommonTranslation('ALL')},
						{"id":"STUDENT", "name":getCommonTranslation('STUDENT')},
						{"id":"APPLICANT", "name":getCommonTranslation('APPLICANT')}
						]
				}),
				itemId:'userType',
				fieldLabel: getCommonTranslation('USER_TYPE'),
				displayField: 'name',
				    valueField: 'id',
				value:'ALL',
				listeners:{
					afterrender:function(cmp){
						Ext.defer(function(){
							cmp.setValue('ALL');
						},250)
						
					}
				}

			
			},{

				xtype: 'customcombobox',
				name:'setupType',
				editable:false,
				store: Ext.create('Ext.data.Store', {
					fields: ['id', 'name'],
					data : [
						{"id":"ALL", "name":getCommonTranslation('ALL')},
						{"id":"HOSTEL_GENERAL_SETUP", "name":getFeeAndPaymentCommonTranslation('GENERAL_APPLICATION')},
						{"id":"WAITING_LIST_SETUP", "name":getFeeAndPaymentCommonTranslation('WAITING_LIST_APPLICATION')}
						]
				}),
				itemId:'setupType',
				fieldLabel: getCommonTranslation('SETUP_TYPE'),
				displayField: 'name',
				    valueField: 'id',
				value:'ALL',
				listeners:{
					afterrender:function(cmp){
						Ext.defer(function(){
							cmp.setValue('ALL');
						},250)
						
					}
				}

			

			}, {
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name: 'accountTermId',
				itemId: 'accountTermId',
				displayField : 'value',
				valueField : 'id',
				store:'common.AcademicTermStore',
				editable: false,
				forceSelection:true,
				msgTarget: 'qtip'
			},{  
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('SETUP_CODE_NAME'),
				name: 'setupCodeName',
				itemId: 'setupCodeName',
                enableKeyEvents: true,
                vtype: 'NospaceAsInput',
                store: 'hostel.HostelApplicationSetup.SetupCodeNameStore',
    			width:226,
    			valueField: 'id',
    			displayField: 'displayVal',
    			queryParam:'codeOrName',
    			minChars:3,
    			typeAhead:false,
    			triggerAction:'',
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{displayVal}'  +
    					'</div>';
    				}
    			}
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'customcombobox',
				name: 'status',
				editable:false,
				fieldLabel: getCommonTranslation('STATUS'),
				store: Ext.create('Ext.data.Store', {
					fields: ['id', 'name'],
					data : [
						{"id":"ALL", "name":getCommonTranslation('ALL')},
						{"id":"ACTIVE", "name":getCommonTranslation('ACTIVE')},
						{"id":"INACTIVE", "name":getCommonTranslation('INACTIVE')}
						]
				}),
				itemId: 'status',
				valueField: 'id',
				displayField: 'name',
				value:'ALL',
				listeners:{
					afterrender:function(cmp){
						Ext.defer(function(){
							cmp.setValue('ALL');
						},250)
						
					}
				}
			
			},
			{
	        	xtype: 'checkboxfield',
	        	labelAlign: 'right',
	        	style:{
	        		//marginLeft:'8px',
	        		marginTop:'25px'
	        	},
	        	itemId:'setupWithoutMapping',
	        	boxLabel: getCommonTranslation('SETUP_WITHOUT_MAPPING'),
	        	name: 'setupWithoutMapping'
	        }
			]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchHostelSetup',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtnItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});